/*==========================================================================
*
*  Pexeso - edukacna hra
*  by Brandy
*  pouzite BonbliotFramework (c)
*
*  - Zobrazi karty, ktore treba korektne sparovat
*
*==========================================================================
*/

#include <ddraw.h>     //Direct Draw 
#include <mmsystem.h>  //koli LPWAVEFORMATEX v <dsound.h> a.i.
#include <dsound.h>    //Direct Sound

//----------------------
#include "DBonbliotFW.h"    //hlavicka hlavnej kniznice, FrameWork by Bonbliot (c)
//----------------------

int mx;  //poloha mysi
int my;

//==================
bf_CDas_Surface  rezia;
bf_CDAS  kurzor;
bf_CDas_Surface  sprite_srf;
bf_CDAS *p_sprite_plane;   //i tak se da
//==================

//-----------------------------------------------
// App
//-----------------------------------------------
class CMyApp : public bf_CAppScreen
{
public:
  CMyApp(HINSTANCE hInstance, int nCmdShow, char* cLocApp_INI);
  ~CMyApp();
  virtual void Do_LOAD_SRF();
  virtual void Do_RELEASE_SRF();
  virtual void Do_RESTORE_SRF();
  virtual void Init();
  virtual int SetupVisual();
  //virtual void Init2();
  virtual void HandleWMInteraction(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
  virtual bool HandleFWInteraction(int iID, int ivalue, bf_CPos *p_pol = NULL);
  virtual void ChangedResolution(int maxx_old, int maxy_old, int maxx_new, int maxy_new);
  virtual void Redraw_Screen( LPDIRECTDRAWSURFACE p_lpDDS );
  virtual void DrawCursor( LPDIRECTDRAWSURFACE p_lpDDS );
};

//----------------------------------------------- 
// Konstruktor
//-----------------------------------------------
CMyApp::CMyApp(HINSTANCE hInstance, int nCmdShow, char* cLocApp_INI) : bf_CAppScreen(hInstance, nCmdShow, cLocApp_INI)
{
   p_sprite_plane = new bf_CDAS(this, 20,30);  //vytvorit a zaradit, zaevidovat k detom App-ky
                                               //(tym bude interaktivne na drag&drop a autovykreslovane) 
};

//-----------------------------------------------
// destruktor
//-----------------------------------------------
CMyApp::~CMyApp()
{
};

//-----------------------------------------------
// nahratie SRF
//-----------------------------------------------
void CMyApp::Do_LOAD_SRF()
{
  rezia.LOAD_SURFACE((char*) "rezia.bmp");
  rezia.BC_SET(0, 0);
  rezia.TC_SET(3, 3);

  sprite_srf.LOAD_SURFACE((char*) "sprite_plane.bmp");
  sprite_srf.TC_SET(2, 2);
};

//----------------------------------------------------------------
// Uvolnit vsetky objekty surfaces
//----------------------------------------------------------------
void CMyApp::Do_RELEASE_SRF()
{
  rezia.RELEASE_SURFACE();
  sprite_srf.RELEASE_SURFACE();
}

//----------------------------------------------------------------
// Restore objektov surfaces
//----------------------------------------------------------------
void CMyApp::Do_RESTORE_SRF()
{
  rezia.RESTORE_SURFACE();
  sprite_srf.RESTORE_SURFACE();
}

//----------------------------------------------------------------
// Init inicializacie
//----------------------------------------------------------------
void CMyApp::Init()
{
  //zapiname log? 
  //bf_LOG_ON = true;
  //bf_LOG_ON = false;  //vypnut
  bf_LOG_SetONOFF( 1 );

  //zapiname zvuky?
  bf_DSO_ONOFF = true;
  //bf_DSO_ONOFF = false;  //vypnut

  kurzor.Das_Surface = &rezia;
  kurzor.REGISTER(5, 10);
  kurzor.REGISTER(25, 10);
  kurzor.x = 100;
  kurzor.y = 100;

  p_sprite_plane->Das_Surface = &sprite_srf;
  p_sprite_plane->REGISTER_CS();
  //p_sprite_plane->x = 20; p_sprite_plane->y = 30;
}

//-----------------------------------------------
// Nastavi vizual, dizajn dialogu
//-----------------------------------------------
int CMyApp::SetupVisual()
{
  bf_CAppScreen::SetupVisual(); //obsluzit najprv predka (od koho je App odvodena)
  return 0;
}

//----------------------------------------------------------------
// Spracovanie WM 
//----------------------------------------------------------------
void CMyApp::HandleWMInteraction(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
  //hWnd_GLOB = hWnd;
  //int hod;
  //int i;

  switch (message)
  {

  case WM_CREATE:
    break;

  case WM_KEYDOWN:

    /*
    switch (wParam)
    {
    case VK_ESCAPE:       //koniec aplikacie
    case VK_F12:
      Close();
      break;
    }
    */
    break;

  case WM_LBUTTONDOWN:      //lavy klik mysou
    kurzor.SF(1);
    break;

  case WM_LBUTTONUP:        //lavy klik mysou (UP) 
    kurzor.SF(0);
    break;

  case WM_MOUSEMOVE:        //pohyb mysou
    mx = LOWORD(lParam);
    my = HIWORD(lParam);
    kurzor.x = mx;
    kurzor.y = my;
    break;

  case WM_TIMER:            //periodicke aktivity na timer
    if (wParam == 1) //BTFW main timer
    {
      if (p_sprite_plane->state != 2) p_sprite_plane->x += 2;
      if (p_sprite_plane->x > m_MAXX + 200) p_sprite_plane->x = -600;
    }
    break;
  }
}


//----------------------------------------------------------------
// Da priestor na akciu 
//----------------------------------------------------------------
bool CMyApp::HandleFWInteraction(int iID, int ivalue, bf_CPos *p_pol)
{
  //postup cez dimenziu predkov
  bool l_b = bf_CAppScreen::HandleFWInteraction(iID, ivalue, p_pol);  //bud tu obsluzit class predka

  switch (iID)
  {
  case 123:  //dummy
    break;
  }

  return l_b;
}

//----------------------------------------------------------------
// Volane po zmene rozmerov obrazovky
//----------------------------------------------------------------
void CMyApp::ChangedResolution(int maxx_old, int maxy_old, int maxx_new, int maxy_new)
{
  //postup cez dimenziu predkov (vratit funkcnost predkovi, lebo cez virtual bola obidena, prepisana)
  bf_CAppScreen::ChangedResolution(maxx_old, maxy_old, maxx_new, maxy_new);  //obsluzit class predka
}

//----------------------------------------------------------------
// Prekreslit celu scenu 
//----------------------------------------------------------------
void CMyApp::Redraw_Screen( LPDIRECTDRAWSURFACE p_lpDDS )
{
  //<--- vymazat
  DDSURFACE_ZMAZ(p_lpDDS, 500);

  //<--- poloz sprite_plane (info riadok)
  //p_sprite_plane->DRAW(p_lpDDS);  //ani netreba, je zaregistrovany v CHL

}

//----------------------------------------------------------------
// Vykreslit kurzor
//----------------------------------------------------------------
void CMyApp::DrawCursor( LPDIRECTDRAWSURFACE p_lpDDS )
{
  //<--- poloz kuzor
  kurzor.DRAW(p_lpDDS);
}

//==============================================================================

//----------------------------------------------------------------
// Vstupny bod pre Appku
//----------------------------------------------------------------
int PASCAL WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance,
  LPSTR lpCmdLine, int nCmdShow)
{
  //--- odpalenie appky cez Execute disciplinu
  //bf_CAppScreen *pAPP = new bf_CAppScreen(hInstance, nCmdShow, (char*) "PEXESO.INI");  //toto uz nie
  CMyApp *pAPP = new CMyApp(hInstance, nCmdShow, (char*) "PEXESO.INI");
  pAPP->SetBackground(-1, (char*)"", false );   //ziadna farba pozadia, ziaden obraz ako podklad, ziadne logo
  pAPP->SetAppInfo((char*)"Pexeso", (char*)"(verzia: 1.0)", (char*)"Branislav Lehotsk", &rezia, 20, 40);
  pAPP->SetSysCursor( false );
  pAPP->SetLang(bf_c_Lang_SK);
  pAPP->Execute();
  delete pAPP;
  return 0;
}
