/*==================================================================================================================
 -- 
 --  UI library for DirectDraw driven PC programes (header DBonbliotFW.h)
 --  Obsahuje:
 --    implementaciu hlavne DirectDraw Animated Sprite (DAS) a DirectDraw User List Interaction (DUI)
 --    implementacia dalej:
 --     BF_GETs    //gettery,settery pre interne premenne kniznice
 --     BF_LOG     //logy/hlasky ladiace, runtime chybove a.i.
 --     BF_DSRFC   //surface
 --     BF_ARRE    //auto realokovatelna kolekcia
 --     BF_DAS     //zakladna kniznica s anim. sprite
 --     BF_PolCHLO //CHL Owner
 --     BF_Dialog  //dialog
 --     BF_EDB     //kniznica na editbox
 --     BF_DFO     //folie
 --     BF_DSO     //zvuky (inspiracia fbsound.c by Microsoft)
 --     BF_DUI     //listova ponuka - dui (CDUI)
 --     BF_DUIR    //dui rosirena o rolovatelnost (CDUIR)
 --     BF_BMP     //kniznica na vytvaranie/grabovanie .bmp
 --     BF_FSI     //operacie s filesystem-om
 --     BF_KM      //konstruct. mode, pomocka pri ladeni
 --     BF_UHSPol  //stromove hierarchie
 --     BF_UTL     //utility
 --     BF_DSGN    //default design
 --     BF_APP     //aplikacia
 --  by Branislav Lehotsk for Bonbliot (c)
 --
 -- History:
 --  $BL ?.?.2019 publikovanie verzie 3.1.
 ==================================================================================================================*/

#ifndef __DBONBLIOTFW_PUBL_H__
#define __DBONBLIOTFW_PUBL_H__

#include <io.h>  //koli _find*:  '_finddata_t', '_findfirst' , potrebuje to DBMP, FSI 
#include <assert.h>  //koli vynimkam assert()
#include <math.h>    //aj koli sqrt v KM

//=== Classes registration ===================================================
//kat.A
#define class_id_bf_CPos           0
#define class_id_bf_CIcon          1
#define class_id_bf_CDAS           2
#define class_id_bf_CDS            3
#define class_id_bf_CButton        4
#define class_id_bf_CSlider        5
#define class_id_bf_CSwitch        6
#define class_id_bf_CEDB          7
#define class_id_bf_CPosIcon       8
#define class_id_bf_CLabel         9
#define class_id_bf_CDecor         10
//kat.B
#define class_id_bf_CDUI           11
#define class_id_bf_CDUIR          12
#define class_id_bf_UTL_CDUIR_THMFILE   121
#define class_id_bf_UTL_CDUIR_DIR  122
#define class_id_bf_CDialog_EFFECT  13
#define class_id_bf_CDialog        14
#define class_id_bf_CFoliaText      15
#define class_id_bf_CFoliaFaz       16
#define class_id_bf_CFoliaIcon      17
#define class_id_bf_CFoliaDekor     18
#define class_id_bf_CUHTPos         19
#define class_id_bf_CPosCHLO        20
#define class_id_bf_CAppScreen      21
#define class_id_bf_CScrollBar      22

typedef struct
{
  int class_id;	
  char text [20+1];
} S_CLASS_PROP;

S_CLASS_PROP bf_array_class_name [] =
{
  {class_id_bf_CPos,  "bf_CPos"},
  {class_id_bf_CIcon, "bf_CIcon"},
  {class_id_bf_CDAS,  "bf_CDAS"}, 
  {class_id_bf_CDS,   "bf_CDS"},   
  {class_id_bf_CButton, "bf_CButton"}, 
  {class_id_bf_CSlider,"bf_CSlider"},
  {class_id_bf_CSwitch,"bf_CSwitch"},
  {class_id_bf_CEDB, "bf_CEDB"}, 
  {class_id_bf_CPosIcon, "bf_CPosIcon"},
  {class_id_bf_CLabel,"bf_CLabel"}, 
  {class_id_bf_CDecor,"bf_CDecor" },
  {class_id_bf_CDUI,  "bf_CDUI"}, 
  {class_id_bf_CDUIR, "bf_CDUIR"},
  {class_id_bf_UTL_CDUIR_THMFILE, "bf_UTL_CDUIR_THMFILE"},
  {class_id_bf_UTL_CDUIR_DIR,  "bf_UTL_CDUIR_DIR"},
  {class_id_bf_CDialog_EFFECT, "bf_CDialog_EFFECT"}, 
  {class_id_bf_CDialog,   "bf_CDialog"},  
  {class_id_bf_CFoliaText, "bf_CFoliaText"},
  {class_id_bf_CFoliaFaz,  "bf_CFoliaFaz"}, 
  {class_id_bf_CFoliaIcon, "bf_CFoliaIcon"},
  {class_id_bf_CFoliaDekor,"bf_CFoliaDekor"},
  {class_id_bf_CUHTPos,    "bf_CUHTPos"}, 
  {class_id_bf_CPosCHLO,   "bf_CPosCHLO"},  
  {class_id_bf_CAppScreen, "bf_CAppScreen"},
  {class_id_bf_CScrollBar, "bf_CScrollBar"} 
};
#define class_index_LAST            23

//============================================== bf_GETs (Get-tery, Set-tery) ==============================
//__declspec(dllexport) HWND bf_Get_APP_hWnd_GLOB();   //tento je pri APP

__declspec(dllexport) int bf_Get_MAXX();
__declspec(dllexport) int bf_Get_MAXY();
__declspec(dllexport) int bf_Get_SX();
__declspec(dllexport) int bf_Get_SY();

__declspec(dllexport) int bf_Get_CIcon_default_transparency();
__declspec(dllexport) void bf_Set_CIcon_default_transparency(int hod);

__declspec(dllexport) int bf_Get_Lang();
__declspec(dllexport) void bf_Set_Lang(int hod);

struct bf_DSGN_Struct;
__declspec(dllexport) bf_DSGN_Struct *bf_Get_Ref_DSGN_Struct();

//============================================== bf_LOG_* ===================================================
struct bf_LOG_Set_struct
{   // Zap/Vyp cez instanciu, treba pri pouziti dll riesenia
  __declspec(dllexport) bf_LOG_Set_struct(int hodn);
};

__declspec(dllexport) void bf_LOG_SetONOFF(int hodn);
__declspec(dllexport) void bf_LOG_Reset(char * text);
__declspec(dllexport) void bf_LOG_Zapis(char * text);
__declspec(dllexport) void bf_LOG_Zapis_F(char * text, int reset = 0);

__declspec(dllexport) void _bf_LOG_(char *subor, int riadok, char *text);
__declspec(dllexport) void _bf_LOG_(const char *subor, int riadok, const char *text);
__declspec(dllexport) void _bf_LOG_(char *subor, int riadok, char *text, int c1);
__declspec(dllexport) void _bf_LOG_(const char *subor, int riadok, const char *text, int c1);
__declspec(dllexport) void _bf_LOG_(char *subor, int riadok, char *text, int c1, int c2);
__declspec(dllexport) void _bf_LOG_(const char *subor, int riadok, const char *text, int c1, int c2);
__declspec(dllexport) void _bf_LOG_(char *subor, int riadok, char *text, int c1, int c2, int c3);
__declspec(dllexport) void _bf_LOG_(const char *subor, int riadok, const char *text, int c1, int c2, int c3);
__declspec(dllexport) void _bf_LOG_(char *subor, int riadok, char *text1, char *text2);
__declspec(dllexport) void _bf_LOG_(const char *subor, int riadok, const char *text1, const char *text2);
__declspec(dllexport) void _bf_LOG_(char *subor, int riadok, char *text1, char *text2, int c1);
__declspec(dllexport) void _bf_LOG_(const char *subor, int riadok, const char *text1, const char *text2, int c1);

#define bf_LOG0( text )             _bf_LOG_( __FILE__, __LINE__, text ) 
#define bf_LOG1( text, c1 )         _bf_LOG_( __FILE__, __LINE__, text, c1 ) 
#define bf_LOG2( text, c1, c2 )     _bf_LOG_( __FILE__, __LINE__, text, c1, c2 ) 
#define bf_LOG3( text, c1, c2, c3 ) _bf_LOG_( __FILE__, __LINE__, text, c1, c2, c3 ) 
#define bf_LOGT( text1, text2 )     _bf_LOG_( __FILE__, __LINE__, text1, text2 ) 
#define bf_LOGT1( text1, text2, c1 ) _bf_LOG_( __FILE__, __LINE__, text1, text2, c1 )
#define bf_ERROR( text )            _bf_LOG_( __FILE__, __LINE__, "BTFW ERROR: ", text ) 


//=== misc_ddutil_bl =============================================================================================

//extern IDirectDrawPalette * DDLoadPalette(IDirectDraw *pdd, LPCSTR szBitmap);
extern "C" __declspec(dllexport) IDirectDrawPalette * DDLoadPalette(IDirectDraw *pdd, LPCSTR szBitmap);
//TODO: prehodnotit: aj dalsie sem spublikovat?

//========================== BF_DSRFC_w.cpp ==================================================================

//------------------------------------------------------
// Faza ~ vysek, vyrez zo surface
//------------------------------------------------------
struct bf_TPHASE
{  
  int XL;
  int YH;
  int XP;
  int YD;
  int SIR;
  int VYS;
  
  __declspec(dllexport) bf_TPHASE() { XL = YH = XP = YD = 0;  SIR = VYS = 100; };   //default 
  __declspec(dllexport) bf_TPHASE( int xxL, int yyH, int ssir, int vvys ) 
        { XL=xxL; YH=yyH; XP=xxL+ssir-1; YD=yyH+vvys-1; SIR=ssir; VYS=vvys; };  
  //__declspec(dllexport) virtual ~bf_TPHASE() {};
};

//------------------------------------------------------
// bf_CDas_Surface - Objekt povrchovej roviny (z nej su zobrazovane objekty bf_CIcon a bf_CDAS)
//------------------------------------------------------
class bf_CDas_Surface  
{
public:
  LPSTR subor_nazov;              // sub., podla ktoreho ma byt zkonstruovany dat.surface
  LPDIRECTDRAWSURFACE SURFACE;    // fyzicky surface
  int srf_sir;                    // rozmery surface      
  int srf_vys;
  WORD TC;      // priesvitna farba (Transparent Color)
  WORD BC;      // farba okraja, hranica faz (Boundary Color)
  bool stretched;
  
  //int class_id;  to uz nie, to nech maju len potomkovia CPol
  char instance_name[30];  //max 30 znakov

  void Init();   //jadro volane konstruktormi  
  __declspec(dllexport) bf_CDas_Surface();
  __declspec(dllexport) bf_CDas_Surface( char *iname );
  __declspec(dllexport) virtual ~bf_CDas_Surface();
  __declspec(dllexport) void LOAD_SURFACE( LPDIRECTDRAW p_lpDD, LPSTR subor );
  __declspec(dllexport) void LOAD_SURFACE( LPSTR subor );
  //__declspec(dllexport) void LOAD_SURFACE( const char* subor ); 
  //__declspec(dllexport) void LOAD_SURFACE( const char subor[] );
  __declspec(dllexport) void RELOAD_SURFACE(); //toto sa hodi pri zmene rozlisenia grafiky - ChangedResolution()
  __declspec(dllexport) void LOAD_SURFACE_2_stretch( LPDIRECTDRAW p_lpDD, LPSTR subor, int sir, int vys );
  __declspec(dllexport) void LOAD_SURFACE_2_stretch( LPSTR subor, int sir, int vys );
  __declspec(dllexport) HRESULT RESTORE_SURFACE();
  __declspec(dllexport) void RELEASE_SURFACE();
  __declspec(dllexport) void DRAW( LPDIRECTDRAWSURFACE d_SRF, int xx, int yy );
  __declspec(dllexport) void DRAW( int xx, int yy );
  __declspec(dllexport) void DRAW_ALPHA( LPDIRECTDRAWSURFACE d_SRF, int xx, int yy, DWORD alpha );  
  __declspec(dllexport) void Draw_Rect( LPDIRECTDRAWSURFACE d_SRF, int xx, int yy, RECT RR );
  __declspec(dllexport) void Draw_Rect( int xx, int yy, RECT RR );
  __declspec(dllexport) void Draw_Center( LPDIRECTDRAWSURFACE d_SRF );
  __declspec(dllexport) void Draw_Center();
  __declspec(dllexport) void TC_SET(int xx, int yy); 
  __declspec(dllexport) void BC_SET(int xx, int yy); 
  __declspec(dllexport) bf_TPHASE FOCUS_PHASE(int xx, int yy);
  __declspec(dllexport) bf_TPHASE FOCUS_PHASE_CS();

  __declspec(dllexport) void DRAW_PHASE( LPDIRECTDRAWSURFACE  d_SRF, int x, int y, bf_TPHASE FF, int extra_orez ); 
  __declspec(dllexport) void DRAW_PHASE_Z( LPDIRECTDRAWSURFACE  d_SRF, int x, int y, bf_TPHASE FF, int extra_orez ); 
  __declspec(dllexport) void DRAW_PHASE_2( LPDIRECTDRAWSURFACE  d_SRF, int L, int P, int H, int D, int x, int y, bf_TPHASE FF );

  __declspec(dllexport) void Draw_Stretch_1( LPDIRECTDRAWSURFACE d_SRF, RECT RRd, RECT RRs );
  __declspec(dllexport) void Draw_Stretch_1( RECT RRd, RECT RRs );
  __declspec(dllexport) void Draw_Stretch_2( LPDIRECTDRAWSURFACE d_SRF, RECT RRd );
  __declspec(dllexport) void Draw_Stretch_2( RECT RRd );
  __declspec(dllexport) void Draw_Stretch_3( LPDIRECTDRAWSURFACE d_SRF, RECT RRs );
  __declspec(dllexport) void Draw_Stretch_3( RECT RRs );
  __declspec(dllexport) void Draw_Stretch_4( LPDIRECTDRAWSURFACE d_SRF );
  __declspec(dllexport) void Draw_Stretch_4();
};


//======================== BF_DAS_w.cpp ===================================================================================

//------------------------------------------------------
// Globalky dalsie
//------------------------------------------------------

//static COLORREF bf_glob_COLORREF_sed_tlac = RGB(216,  216,  216 ); //seda pre tlacidlo
 
static HPEN bf_glob_pero_ram_sed = NULL;      //speci pre level efekt (toolbar style)
static HPEN bf_glob_pero_blue1 = NULL;        //pom.

static HBRUSH bf_glob_stet__sed_tlac = NULL; //vyplnt, farba default tlacitka
static HBRUSH bf_glob_stet__dui_vybr  = NULL; //DUI vybrana polozka = ma focus
static HBRUSH bf_glob_stet__dui_aktiv = NULL; //DUI aktivovana polozka = potvrdena klikom
static HBRUSH bf_glob_stet__dui_popup = NULL; //DUI popup polozka = otvara podmenu pri ziskani focusu

char* bf_Get_class_name( int cclass_id );
extern "C" __declspec(dllexport) void DDSURFACE_ZMAZ( LPDIRECTDRAWSURFACE  d_SRF, DWORD farba );
extern "C" __declspec(dllexport) bool bf_glob_test_in_rect( int xl,int yh,int xp,int yd,  int xx, int yy );
extern "C" __declspec(dllexport) void bf_glob_Level_efekt( HDC pDC, RECT *R, int state );
extern "C" __declspec(dllexport) void bf_glob_Level_efekt2_fill( HDC pDC, RECT *R, int state );
extern "C" __declspec(dllexport) void bf_glob_Text( HDC pDC, int xx, int yy, COLORREF farba, char* text );
extern "C" __declspec(dllexport) void bf_glob_Text_font( HDC pDC, int xx, int yy, COLORREF farba, HFONT font, char* text );
extern "C" __declspec(dllexport) void bf_glob_Text_draw_font( HDC pDC, LPRECT lpRect, UINT uFormat, COLORREF farba, HFONT font, char* text );  //LPCTSTR lpchText
extern "C" __declspec(dllexport) void bf_glob_Text_srf( LPDIRECTDRAWSURFACE d_SRF, int xx, int yy, COLORREF farba, char* text );
extern "C" __declspec(dllexport) void bf_glob_Ramik( HDC pDC, RECT *pR, int cislo_pera );  //HPEN pero
extern "C" __declspec(dllexport) void bf_glob_Orez_Rect2Screen( RECT *R );
//z tohoto som spravil aj internu fciu bf_dsrfc_OREZ_Rect2LPHD() pre potreby DSRFC
extern "C" __declspec(dllexport) bool bf_glob_OREZ_Rect2LPHD( int L, int P, int H, int D,  int *xx, int *yy,  RECT *rrect );
extern "C" __declspec(dllexport) void bf_glob_ZISTI_ROZMER_TEXTU( char *ttext, HFONT ffont_hnd, int *SIR, int *VYS );
extern "C" __declspec(dllexport) double bf_glob_Distance( int ax, int ay, int bx, int by );
extern "C" __declspec(dllexport) void bf_glob_GetSizeBitmap( LPCSTR szBitmap, int *ssir, int *vvys);


//------------------------------------------------------
// bf_CIcon - objekt predstavuje solo obrazok ako taky.
// Nema vlastnu polohu, teda ani nie je potomkom bf_CPos. Registruje jedinu fazu z konkretnej povrchovej roviny
//------------------------------------------------------
class bf_CIcon
{
public:
  bf_CDas_Surface *Das_Surface;
  bool srf_owner;
  
  bf_TPHASE faza;
  bool visible2;
  
  //static int default_transparency;  //pri dll priamo nepouzitelne, treba cez internu globalku bf_glob_Set_CIcon_default_transparency(.)

  void Init_1( LPDIRECTDRAW p_lpDD, LPSTR subor );                   //jadro volane konstruktormi
  void Init_2( bf_CDas_Surface *ppDas_Surface, int xx=0, int yy=0 ); //jadro volane konstruktormi
  __declspec(dllexport) bf_CIcon();
  __declspec(dllexport) bf_CIcon( LPDIRECTDRAW p_lpDD, LPSTR subor );
  __declspec(dllexport) bf_CIcon( LPSTR subor );  //cez staticky bf_lpDD (resp. zapuzdrene m_lpDD v bt_Application?)
  __declspec(dllexport) bf_CIcon( bf_CDas_Surface *ppDas_Surface, int xx, int yy );  //so zameranim fazy, t.j.: REGISTER( xx, yy ); resp. REGISTER_CS();
  __declspec(dllexport) bf_CIcon( bf_CDas_Surface *ppDas_Surface );
  __declspec(dllexport) bf_CIcon( bf_CDas_Surface *ppDas_Surface, bf_TPHASE ffaza );
  __declspec(dllexport) virtual ~bf_CIcon();

  __declspec(dllexport) void REGISTER(int xx, int yy);
  __declspec(dllexport) void REGISTER_CS();
  __declspec(dllexport) void REGISTER_PREBER( bf_CIcon* p_icon );
  __declspec(dllexport) void REGISTER_COPY( bf_CIcon* p_icon ) { REGISTER_PREBER( p_icon ); };  //sinonymum

  __declspec(dllexport) virtual void GetSize2( int *ssir, int *vvys );
  void DRAW_NUDZOVO( LPDIRECTDRAWSURFACE d_SRF, int x, int y );
  __declspec(dllexport) void DRAW( LPDIRECTDRAWSURFACE d_SRF, int x, int y );
  __declspec(dllexport) void DRAW_2( LPDIRECTDRAWSURFACE d_SRF, int L,int P,int H,int D, int x, int y ); //so vseobecnym orezom
  __declspec(dllexport) void DRAW_2( LPDIRECTDRAWSURFACE d_SRF, int x, int y );  //s orezom na celu obrazovku
  __declspec(dllexport) void DRAW_3_centr( LPDIRECTDRAWSURFACE d_SRF, int L,int P,int H,int D, int x, int y, int centr_mod = 0 );
};


//=== ARRE BEG ==============================================================

typedef void* Pvoid;

#define DETACH        1
#define NODETACH      2

//------------------------------------------------------
// bf_CARRE - Array Extendable = kolekcia, auto-realokovatelne pole;
// eviduje sadu prvkov (void* smernikov) v "dynamicky zijucom" linearnom poli/vektore
//------------------------------------------------------
class bf_CARRE
{
public:
  void **ARR;   //hlavna struktura - tu je zavesene pole smernikov  *void (dynamicke)
                //(teda to iste ako "Pvoid *ARR" )
  int akt_alloc;        //kolko je aktualne alokovanych	
  int next_alloc_delta; //o kolko sa ma doalokovat pri vycerpani miesta (ak=0 => vzdy dvojnasobok akt_alloc)
  int mode;             //mod uvolnovania: DETACH/NODETACH (ci automaticky rusit zavesene)
  bool index_check_mode; //ci pred pristupom na bunku kontrolovat index na interval <0,count-1>  (default, doporucene) 
	
  int count;            //kolko je aktualne obsadenych (realne naplnenych/pouzitych)
    
  __declspec(dllexport) bf_CARRE( int iinic_alloc = 0, int nnext_alloc = 0, int mmode = NODETACH );
  __declspec(dllexport) virtual ~bf_CARRE();
  __declspec(dllexport) void DetachAll(void);

  __declspec(dllexport) void ADD( void *pp ); // synonymum
  __declspec(dllexport) void Add( void *pp ); //prida polozku na koniec
  __declspec(dllexport) void Del();           //odoberie polozku z konca
  __declspec(dllexport) void Trunc();
  __declspec(dllexport) void Zhod_count();    //zhodit pocitadlo (bacha, dost intimna vec, volat by mal hostitel len ak korektne uvolnil navesane veci)
  __declspec(dllexport) void SET_count( int cnt ) { if ( cnt >= 0 ) count = cnt; };  //natvdo zmeni interne pocitadlo
  
  __declspec(dllexport) void * operator [](int i);   //indexovy operator, vrati ARR[i] alebo NULL ak je index mimo rozsah
  __declspec(dllexport) void * GET(int i);           //vrati smernik z ARR[i], robi to iste ako operator[] 
  __declspec(dllexport) void SET(int i, void *pp );  //nastavi ARR[i] na podhodenu instaciu zadanu smernikom
  __declspec(dllexport) void Blenduj(int i);         //zhodi ARR[i] na NULL
  
  __declspec(dllexport) void ShiftUp(int i);   //posunom zdola zaplata "NULL-dieru"
  __declspec(dllexport) void ROLL(int ix1, int ix2);  //rotacia << + ix1 vybublat vpravo
  __declspec(dllexport) void ROLR(int ix1, int ix2);  //rotacia >> + ix2 klesnut vlavo
  
  __declspec(dllexport) void VYPIS_LOG(); //<<<<<<< DEBUG
  __declspec(dllexport) void VYPIS_LOG_char();
  __declspec(dllexport) void UVOLNI_char();

};

//=== ARRE END ==============================================================

//=== bf_CPos BEG ==============================================================
class bf_CDialog;
class bf_CPosCHLO;

//------------------------------------------------------
// Objekt ~ univerzalny predok vsetkeho, co ma polohu a s cim pouzivatel moze interagovat (menit polohu, fazu,...)
//------------------------------------------------------
class bf_CPos
{
public:
  int x, y;     //poloha [x,y]
  bool visible;
  bool center;  //priznak centrovania (=su suradnice stredom objektu?)
  int state;     //state (0-bez 1-focus 2-drag)
  bool draggable;
  int drag_distance;
  static int dummy_x, dummy_y;  //autoincrementalne v konstruktore s ID 

  bf_CPos* PARENT; //vazba na rodica
  //bf_CPosCHLO * PARENT; //vazba na rodica
  int rx, ry;     //relativna poloha k rodicovi (ak existuje)

  int class_id;
  char instance_name[30];  //max 30 znakov
  int ID;     //ID instancie (to pomoze parametrizovat design vramci dialogu alebo appky,
              //priradit geometriu)
  bool ad;    //autodestrukcia (= priznak, ci ma instanciu uvolnit destruktor ~bf_CUHTPos, plati teda len pre bf_CPos zapojene v hierarchii) 

  void SET_class_id( int id ) { class_id = id; };
  void SET_instance_name( char *name ) { strcpy_s(instance_name, name); };   /*$BL 4.7.19, nahrada strcpy*/
  
  __declspec(dllexport) bf_CPos();
  __declspec(dllexport) bf_CPos( bf_CPosCHLO *parent, int irx, int iry );
  __declspec(dllexport) bf_CPos( bf_CPosCHLO *parent, int iID );
  void Init();

  void MoveTo( int xx, int yy );       //presun Pol abs. 
  __declspec(dllexport) void MoveToRel( int rrx, int rry );  //presun Pol rel.
  __declspec(dllexport) virtual void Parent_reset();   //aktualizacia polohy vzhladom na rodica 
  __declspec(dllexport) virtual void GO_TO( int xx, int yy );  //presun absolutny na novu polohu
  __declspec(dllexport) virtual void GO_TO_CENTER(int cx, int cy);  // Presun na center
  __declspec(dllexport) /*virtual*/ void GO_TO_REL_CENTER(int rcx, int rcy);  // Presun na center rel.
  
  __declspec(dllexport) virtual void DRAW( LPDIRECTDRAWSURFACE  d_SRF );
  __declspec(dllexport) virtual void DRAW();

  __declspec(dllexport) virtual void GetSize( int *ssir, int *vvys );
  __declspec(dllexport) virtual void SetSize( int ssir, int vvys ) {};
  __declspec(dllexport) virtual bool CanDrag( int mx, int my ); //default artikulacia uchopitelnosti pre Pol
  __declspec(dllexport) virtual bf_CPos* GetShot( int mx, int my );
  __declspec(dllexport) virtual bool INFORM_SELF( int mx, int my, int mtlac );  //{ return false; };
}; 

int bf_CPos::dummy_x = 15;
int bf_CPos::dummy_y = 10;

//------------------------------------------------------
// bf_CUHTPos - rekurzivna dat. struktura n-arny strom (Universalny Hierarchicky Strom) s prvkami bf_CPos
//------------------------------------------------------
class bf_CUHTPos
{
public:
  bf_CUHTPos *PARENT;
  
  bool zivy;
  
  bf_CPos *PRVOK_Pol;  //prvok, instancia bf_CPos, ktoru hostuje tento uzol, nosna vec!
//---------
  bf_CARRE CHL;        //kolekcia potomkov/deti = Child list  (rozumej ale, ze su tam zavesene instancie bf_CUHTPos, nie bf_CPos a navyse detypovane na void)
//---------         //preto treba pretypovavat: ( (bf_CUHTPos*) CHL[i] )->...
//bf_CARRE CHL(0,0, 0 );  //NODETACH lebo ma vlastne obsluzenie uvolnovania
				
  int CHL_maxpoc;   //tymto obmedzime pocet deti
  
  __declspec(dllexport) bf_CUHTPos();
  __declspec(dllexport) bf_CUHTPos( bf_CPos *pPol );
  void Init();
  __declspec(dllexport) virtual ~bf_CUHTPos();
  
  __declspec(dllexport) void DRAW( LPDIRECTDRAWSURFACE  d_SRF );
  __declspec(dllexport) bool INFORM_SELF( int mx, int my, int mtlac );
  __declspec(dllexport) bool INFORM_ME( int *iID );     //hlavne na spatnu vazbu od tlacidiel
  __declspec(dllexport) bool INFORM_SELF_KLAV( int kl );  //na informovanie EDB
  
  __declspec(dllexport) void INIC( bf_CPos * pp );
  __declspec(dllexport) void ADD( bf_CPos *pp, int rrx, int rry );
  __declspec(dllexport) void ADD( bf_CPos *pp );
  __declspec(dllexport) void ADD( bf_CUHTPos *U );
  
  __declspec(dllexport) void zivy_vyhradne();
  __declspec(dllexport) void Parent_reset_deti();
}; 

typedef bf_CUHTPos * Pbf_CUHTPos;

//------------------------------------------------------
// bf_CPosIcon - potomok CPol i CIcon (ikona s polohou)
//------------------------------------------------------
class bf_CPosIcon : public bf_CPos, public bf_CIcon
{
public:
  __declspec(dllexport) bf_CPosIcon( bf_CPosCHLO *parent, int rrx, int rry, LPSTR ssubor );
  __declspec(dllexport) bf_CPosIcon( bf_CPosCHLO *parent, int rrx, int rry, bf_CIcon* p_icon );
  __declspec(dllexport) bf_CPosIcon( bf_CPosCHLO *parent, int iID );
  __declspec(dllexport) bf_CPosIcon( int xx, int yy, bf_CDas_Surface *ppDas_Surface, bf_TPHASE ffaza );
  void Init();
  __declspec(dllexport) virtual ~bf_CPosIcon();
//__declspec(dllexport) void Dsgn_PolIcon_Stock( int rrx, int rry, char *stock_face );
  __declspec(dllexport) void Dsgn_PolIcon_Copy( int rrx, int rry, bf_CIcon* p_icon );
  __declspec(dllexport) void Dsgn_PolIcon_User( int rrx, int rry, bf_CDas_Surface *dsrf, int x1,int y1 );
  __declspec(dllexport) void DRAW( LPDIRECTDRAWSURFACE  d_SRF );  
  __declspec(dllexport) void DRAW();
  //__declspec(dllexport) void SetIcon( char *ttext );
  __declspec(dllexport) virtual void GetSize( int *ssir, int *vvys );
};

//------------------------------------------------------
// bf_CLabel - textova popiska s polohou
//------------------------------------------------------
class bf_CLabel : public bf_CPos
{
public:
  LPSTR text;
  //char *text;
  COLORREF CR_text_color;
  HFONT   font_hnd;
  int size_sir;  //buffer hodnoty
  int size_vys;

//__declspec(dllexport) bf_CLabel( bf_CPosCHLO *parent, int rrx, int rry, char *ttext );
  __declspec(dllexport) bf_CLabel( bf_CPosCHLO *parent, int rrx, int rry, LPSTR ttext );
  __declspec(dllexport) bf_CLabel( bf_CPosCHLO *parent, int iID, LPSTR ttext );
  __declspec(dllexport) bf_CLabel( bf_CPosCHLO *parent, int iID );
  void Init();
  __declspec(dllexport) virtual ~bf_CLabel();
  __declspec(dllexport) void Dsgn( int rrx, int rry, LPSTR ttext );
  __declspec(dllexport) void Dsgn( int rrx, int rry );
  __declspec(dllexport) virtual void DRAW( HDC pDC );
  __declspec(dllexport) void DRAW( LPDIRECTDRAWSURFACE  d_SRF );  
  __declspec(dllexport) void DRAW();
//__declspec(dllexport) void SetText( char *ttext );
  __declspec(dllexport) void SetText( LPSTR ttext );
  __declspec(dllexport) void SetNumber( int vval );
  __declspec(dllexport) virtual void GetSize( int *ssir, int *vvys );
  __declspec(dllexport) void GetEnvelope(RECT *envelope);
};

//------------------------------------------------------
// CLabel s technikou cez Draw Text Rect
//------------------------------------------------------
class bf_CLabel2 : public bf_CLabel
{
public:
  RECT text_rect;
  int tr_sir, tr_vys;

  __declspec(dllexport) bf_CLabel2(bf_CPosCHLO *parent, int iID);
  //__declspec(dllexport) virtual ~bf_CLabel();
  __declspec(dllexport) void Dsgn(int rry, LPSTR ttext);
  __declspec(dllexport) void DRAW(HDC pDC);
  __declspec(dllexport) void GetSize(int *ssir, int *vvys);
 // __declspec(dllexport) void SetSize(int ssir, int vvys);
  //__declspec(dllexport) void GetEnvelope(RECT *envelope);
};

//------------------------------------------------------
// bf_CDecor - dekor
//------------------------------------------------------
class bf_CDecor : public bf_CPos
{
public:
  char typ;
  int sir;  //buffer hodnoty
  int vys;

  __declspec(dllexport) bf_CDecor(bf_CPosCHLO *parent);
  //__declspec(dllexport) bf_CLabel(bf_CPosCHLO *parent, int rrx, int rry, int ssir, int vvys);
  void Init();
  //__declspec(dllexport) virtual ~bf_CDecor();
  __declspec(dllexport) void Dsgn(int rrx, int rry, int ssir, int vvys);
  void H_ciara(HDC pDC, int xx1, int xx2, int yy, int mmod);
  void V_ciara(HDC pDC, int xx, int yy1, int yy2);
  //__declspec(dllexport) void DRAW(HDC pDC);
  __declspec(dllexport) void DRAW(LPDIRECTDRAWSURFACE  d_SRF);
  //__declspec(dllexport) void DRAW();
  __declspec(dllexport) void GetSize(int *ssir, int *vvys);
  __declspec(dllexport) void SetSize(int ssir, int vvys);
  //__declspec(dllexport) void GetEnvelope(RECT *envelope);
};


//------------------------------------------------------
//======================================== BF_EDB_w.cpp 
//------------------------------------------------------
class bf_CEDB : public bf_CPos
{
public:
    int sir; int vys;
    RECT rect;          //geometria policka
    char EDITTEXT[200]; //aktualny text
    int EDITTEXT_pos;   //pozicia posledneho znaku 
	  int EDITTEXT_max;   //max.povoleny pocet znakov
    //bool  ma_focus;
	
	  HBRUSH  stet_podkl;     //stetec pre poklad (ak pokl_typ = 2)
	  HPEN    pero_ram_sed;   //pri level efekte (toolbar style)
    HFONT   font_hnd;
    //int     font_sir;
    //int     font_vys;
	
  __declspec(dllexport) bf_CEDB( bf_CPosCHLO *parent, int irx, int iry );
  __declspec(dllexport) bf_CEDB( bf_CPosCHLO *parent, int iID );
  __declspec(dllexport) bf_CEDB( bf_CPosCHLO *parent, int iID, int iedit_max, HFONT ffont_hnd );
  void Init();
  __declspec(dllexport) virtual ~bf_CEDB();
  __declspec(dllexport) void Dsgn( int rrx, int rry, int ssir, int vvys );
  __declspec(dllexport) void Level_efekt( HDC pDC, int typ );
  __declspec(dllexport) void DRAW( LPDIRECTDRAWSURFACE  d_SRF );
  __declspec(dllexport) void DRAW();
  __declspec(dllexport) bool INFORM_SELF_KLAV( int kl );
  __declspec(dllexport) virtual void GetSize( int *ssir, int *vvys );
  __declspec(dllexport) virtual void SetSize( int ssir, int vvys ) { sir=ssir; vys=vvys; };
  
  __declspec(dllexport) void Set_Text( char *p_text );
  __declspec(dllexport) void Set_Number( int p_num );
  __declspec(dllexport) char * Get_Text();
};

//-----------------------------------------------------
// bf_CDAS - DirectDraw Animovany Sprite
// Objekt s vlastnou polohou, evidujuci jednu alebo viacere fazy z konkretnej povrchovej roviny
//------------------------------------------------------
class bf_CDAS : public bf_CPos
{
public:
  int vx;             //rychlost

  //bool  disabled;
  bool  drag_ovatelny;

  int zrkadlo;        //ci preklopeny okolo y osi 
  int eui;            //extra user info (pre lubovolne pouzivatelske pouzitelne)

  bf_CDas_Surface *Das_Surface;
  bool srf_vlastnik;

//-----------	
  bf_CARRE  FAZY;      //hlavna struktura - fazy
//-----------	
  
  int akt_faza;        //index aktualnej fazy
  //int pocet_faz;

  WORD TC;        //priehladna farba
  WORD BC;        //farba okraja, hranice fazy

  int void_SIR; int void_VYS;   //nudzove rozmery (ked nenastavena Das_Surface alebo je bez faz )
  bool void_info;
  bf_CLabel * label;    //pripadny label
  int label_shifting;  //ci a o kolko label posunut pri stave 2

  //__declspec(dllexport) bf_CDAS();
  __declspec(dllexport) bf_CDAS( int xx = 200, int yy = 250 );
  __declspec(dllexport) bf_CDAS( char *iname, int xx = 200, int yy = 250 );
  __declspec(dllexport) bf_CDAS( bf_CPosCHLO *parent, int irx, int iry );
  __declspec(dllexport) bf_CDAS( bf_CPosCHLO *parent, int iID );
  void Init1();
  void Init2(); 
  __declspec(dllexport) void Dsgn0_VoidDC( int rrx, int rry, int ssir, int vvys );
  __declspec(dllexport) void Dsgn1_Stock( int rrx, int rry, char *stock_face );
  __declspec(dllexport) void Dsgn2_UserA( int rrx, int rry, bf_CDas_Surface *dsrf, int x1,int y1, int x2,int y2, int x3,int y3 );
  __declspec(dllexport) void Dsgn3_UserB( int rrx, int rry, bf_CDAS* p_DAS );
  __declspec(dllexport) virtual ~bf_CDAS();

  //void LOAD_SURFACE( LPSTR subor);
  __declspec(dllexport) void LOAD_SURFACE( LPDIRECTDRAW p_lpDD, LPSTR subor); 

  __declspec(dllexport) void TC_SET(int xx, int yy); 
  __declspec(dllexport) void BC_SET(int xx, int yy); 
  __declspec(dllexport) void REGISTER(int xx, int yy);
  __declspec(dllexport) void REGISTER_COPY( bf_CDAS* p_DAS );
  __declspec(dllexport) void REGISTER_CS(); 

  __declspec(dllexport) void NF();
  __declspec(dllexport) void SF( int ff );
  __declspec(dllexport) void DRAW_VOID( LPDIRECTDRAWSURFACE  d_SRF );
  __declspec(dllexport) void DRAW( LPDIRECTDRAWSURFACE  d_SRF );

  bool test_in_rect( int xl,int yh,int xp,int yd,  int xx, int yy );
  __declspec(dllexport) virtual bool INFORM_SELF( int mx, int my, int mtlac );
  __declspec(dllexport) int AktSIR();  //sirka aktualnej fazy
  __declspec(dllexport) int AktVYS();  //vyska aktualnej fazy
  __declspec(dllexport) virtual void AKTIVUJ();

  __declspec(dllexport) virtual void GetSize( int *ssir, int *vvys );
  __declspec(dllexport) virtual void SetSize( int ssir, int vvys ) { void_SIR=ssir; void_VYS=vvys; };
  __declspec(dllexport) bool ZASAH( int mx, int my );
  __declspec(dllexport) bool OSTRY_ZASAH( int mx, int my );
  __declspec(dllexport) void report_faz();
};

//------------------------------------------------------
// Sprajt s jedinou fazou vo velkosti surface
//------------------------------------------------------
class bf_CDS : public bf_CDAS  
{
public:
  __declspec(dllexport) void REGISTER_2();
};

//------------------------------------------------------
// Tlacidlo (prevazne DAS s tromi fazami)
//------------------------------------------------------
class bf_CButton : public bf_CDAS
{
public:
  int vystup;
  int sif;  //Shift info flag (0/1) = info pre vykreslovatela popisky/tvare
  //int stav_prev;  //povodny (minuly)
  __declspec(dllexport) bf_CButton();
  __declspec(dllexport) bf_CButton( char *iname );
  __declspec(dllexport) bf_CButton( bf_CPosCHLO *parent, int irx, int iry, int iID );
  __declspec(dllexport) bf_CButton( bf_CPosCHLO *parent, int iID );
  void Init();
  __declspec(dllexport) ~bf_CButton();

  __declspec(dllexport) void Dsgn_label(int lb_rx, int lb_ry, LPSTR lb_text, COLORREF lb_text_color);

  __declspec(dllexport) bool INFORM_SELF( int mx, int my, int mtlac );   //ci kurzor nad, osloveny
  __declspec(dllexport) bool INFORM_SELF2( int mx, int my, int mtlac );  //ci zmena stavu
  __declspec(dllexport) bool PRESSED();
  __declspec(dllexport) bool PRESSED2();
};

//------------------------------------------------------
// Posuvnik / Slider
//------------------------------------------------------
class bf_CSlider : public bf_CDAS  
{
public:
   //hodnoty OD,    DO ,   aktualna, prave nastavena bezcom 
   int    map_A,   map_B,    map_Aktpoz;       

   int  pol_Min,  pol_Max,  pol_Fix;  //mantinely absolutne k obrazovke
   int rpol_Min, rpol_Max, rpol_Fix;  //mantinely relativne k rodicovi-dialogu

   char pol_Typ;    //'V'-vertikalny  'H'-horizontalny

   __declspec(dllexport) bf_CSlider();
   __declspec(dllexport) bf_CSlider( char *iname );
   __declspec(dllexport) bf_CSlider( bf_CPosCHLO *parent, int iID, int irx, int iry );
   __declspec(dllexport) bf_CSlider( bf_CPosCHLO *parent, int iID );
   void Init();
   __declspec(dllexport) void Dsgn( int stock_face, char ttyp, int rrpol_fix, int rrpol_min, int rrpol_size );

   __declspec(dllexport) bool INFORM_SELF( int mx, int my, int mtlac );
   
   __declspec(dllexport) virtual void Parent_reset();
   __declspec(dllexport) void SR( int mmap_A, int mmap_B );  //SetRange   
   __declspec(dllexport) void Pos_reset();

   __declspec(dllexport) void SP( int hod );  //SetPos
   __declspec(dllexport) int GP();            //GetPos
};

//------------------------------------------------------
// Prepinac / Check box / Radio button
//------------------------------------------------------
class bf_CSwitch : public bf_CDAS  
{
public:
   bool checked;
   int stlac_mod;  //mod stlacania: 0-check style; 1-radio style
   int sif;  //Shift info flag (0/1) = info pre vykreslovatela popisky/tvare
             //(ako pri bf_CButton)
   int group; //skupina (uzitocne pre radio style)

   __declspec(dllexport) bf_CSwitch();
   __declspec(dllexport) bf_CSwitch( char *iname );
   __declspec(dllexport) bf_CSwitch( bf_CPosCHLO *parent, int irx, int iry, int iID);
   __declspec(dllexport) bf_CSwitch( bf_CPosCHLO *parent, int iID );
   void Init();
   __declspec(dllexport) void Dsgn( int sstlac_mod, int irx, int iry, int igroup = 0);
   __declspec(dllexport) void Dsgn_label(int lb_rx, int lb_ry, LPSTR lb_text, COLORREF lb_text_color);

   __declspec(dllexport) bool INFORM_SELF( int mx, int my, int mtlac );
   __declspec(dllexport) void SetCheck(bool value);
   __declspec(dllexport) bool GetCheck();
};

//=== DAS END ==============================================================



//=== DDIALOG BEG ==============================================================

//------------------------------------------------------
// Globalky na vykreslovanie podkladu
//------------------------------------------------------
//TODO: BTFW rename
extern "C" __declspec(dllexport) void bf_CDUI_podklad_efekt_A_biela_siet( LPDIRECTDRAWSURFACE  d_SRF, RECT backgr_rect, bool cier_ram = true );
extern "C" __declspec(dllexport) void bf_CDUI_podklad_efekt_B_mliecny( HDC hdc, RECT backgr_rect );
//TODO?: extern "C" __declspec(dllexport) void bf_CDUI_podklad_efekt_B_mliecny( LPDIRECTDRAWSURFACE  d_SRF, RECT backgr_rect );
//TODO?: extern "C" __declspec(dllexport) void bf_CDUI_Level_efekt( HDC pDC, RECT *R, int state );

//------------------------------------------------------
// DD Dialog EFEKT 
//------------------------------------------------------
class bf_CDialog_EFFECT : public bf_CPos
{
public:
  int sir, vys, pruh_h; 
  int backgr_typ;  //podobne ako v DUI (hodnoty vid. konstruktor)
  bool zamknuty;  //ci je hybatelny
  bool pruh_senzitivnost;  //ci uchopitelny len za horny pruh alebo celou plochou obalky
  
  //LPSTR titulok;  //popis, 'label'
  char titulok[40];
  
  HBRUSH DLG_stet_podkl;  //na podklad
  HBRUSH DLG_stet_pruh;
  HPEN DLG_pero_ram_b;
  HPEN DLG_pero_ram_s1;
  HPEN DLG_pero_ram_s2;
  HPEN DLG_pero_ram_s3;
  bf_CIcon *pDLG_pruh_textur_ikona;
  
  __declspec(dllexport) bf_CDialog_EFFECT();
  __declspec(dllexport) bf_CDialog_EFFECT( int xx, int yy, int ssir, int vvys, char * ttitulok );  //LPSTR
  __declspec(dllexport) ~bf_CDialog_EFFECT();
  __declspec(dllexport) void Vytvor_Init();
  
  __declspec(dllexport) void Center();
  __declspec(dllexport) void GO_TO_CENTER( int xx, int yy );  
  __declspec(dllexport) void DRAW( LPDIRECTDRAWSURFACE  d_SRF );
  
  void DLG_hr_ciara( LPDIRECTDRAWSURFACE  d_SRF, int xx1, int xx2, int yy, int typ );
  //void DLG_Text( LPDIRECTDRAWSURFACE  d_SRF, int xx, int yy, char* text );
  //void Text2( HDC pDC, int xx, int yy, char* text );
  
  __declspec(dllexport) bool INFORM_SELF( int mx, int my, int mtlac );
  //__declspec(dllexport) bool Test_mys_v_rect( int mx, int my );
}; 

//------------------------------------------------------
// DD CPosCHLO : Pos + Child List Owner 
// Spojka v strome instancii - predchodca Dialogu Aj AppScreen, 
//------------------------------------------------------
class bf_CPosCHLO : public bf_CPos
{
public:
  //-----------	hlavna struktura - Zoznam potomkov = Child list  
  //bf_CARRE  CHL(5,5, NODETACH);   //prvky len evidujeme, destruktor ich nema automaticky deletovat
  bf_CARRE  CHL;     //de-facto: (0,0,NODETACH)
                     //bf_CARRE  CHL(0,0, DETACH);
  //-----------	

  __declspec(dllexport) bf_CPosCHLO();
  __declspec(dllexport) bf_CPosCHLO(bf_CPosCHLO *parent, int iID);
  __declspec(dllexport) virtual ~bf_CPosCHLO();
  __declspec(dllexport) virtual int SetupVisual() { return 0; };
  int SetupVisual_Private();

  __declspec(dllexport) virtual void Parent_reset();
  __declspec(dllexport) virtual void GO_TO(int xx, int yy);
  __declspec(dllexport) virtual void DRAW(LPDIRECTDRAWSURFACE  d_SRF);

  __declspec(dllexport) virtual bf_CPos* GetShot(int mx, int my);
  __declspec(dllexport) virtual bool INFORM_SELF(int mx, int my, int mtlac);
  __declspec(dllexport) virtual bool INFORM_SELF_KLAV(int kl);  //na informovanie EDB
  __declspec(dllexport) virtual bool INFORM_ME(int *iID);     //hlavne na spatnu vazbu od tlacidiel
  __declspec(dllexport) virtual bool HandleFWInteraction(int iID, int ivalue, bf_CPos *p_pol = NULL);

  __declspec(dllexport) bf_CPos* FindCHLWithID(int iID);
  __declspec(dllexport) bf_CPos* GetCHLWithIndex(int index);
  __declspec(dllexport) int GetIndexOfCHL(bf_CPos *p_pol);
  __declspec(dllexport) static bool IsClassIdPolCHLO(int cclass_id)
  {
    if (cclass_id == class_id_bf_CPosCHLO
      || cclass_id == class_id_bf_CDialog
      || cclass_id == class_id_bf_CScrollBar
      || cclass_id == class_id_bf_CAppScreen //ehm... to sa dietatu zatial nestane: ak je App, tak je jedina a korenom stromu
      ) return true;
    return false;
  };

  __declspec(dllexport) void ADD(bf_CPos *p_pol);
  __declspec(dllexport) void TOP_DLG(bf_CDialog *p_dlg);
};

//------------------------------------------------------
// DD Dialog
//------------------------------------------------------
class bf_CDialog : public bf_CPosCHLO
{
public:
 
  int sir, vys;  
  //bool backgr_def;  //default podklad (ak false, musi sa volajuci postarat o vykr. podkladu )
  bool backgr_nudzovy;  //len provizorny, nudzovy default podklad?
  
  //-------------------------------
    bf_CDialog_EFFECT  dialog_EFEKT;
  //-------------------------------

  __declspec(dllexport) bf_CDialog();
  __declspec(dllexport) bf_CDialog( bf_CPosCHLO *parent, int iID );
  __declspec(dllexport) virtual ~bf_CDialog();
  
//__declspec(dllexport) virtual int SetupVisual();  //TODO: nastavenie dlg efektu
  __declspec(dllexport) void Dsgn( int rrx, int rry, int ssir, int vvys, int pbackgr_typ );
  
  __declspec(dllexport) virtual void DRAW( LPDIRECTDRAWSURFACE  d_SRF );
  __declspec(dllexport) virtual void DRAW( LPDIRECTDRAWSURFACE  d_SRF, int cast );

  __declspec(dllexport) virtual void GetSize( int *ssir, int *vvys );
  __declspec(dllexport) virtual void SetSize( int ssir, int vvys ) { sir=ssir; vys=vvys; };
  __declspec(dllexport) virtual bool CanDrag( int mx, int my ); //artikulacia uchopitelnosti dialogu
  __declspec(dllexport) bool INFORM_SELF( int mx, int my, int mtlac );
  
  __declspec(dllexport) void GO_TO_CENTER( int xx, int yy );
  __declspec(dllexport) void GO_TOP();
}; 

//------------------------------------------------------
// Scrollbar (posuvnik s dvoma tlacidlami a podkl.dekorom)
//------------------------------------------------------
class bf_CScrollBar : public bf_CPosCHLO
{
public:
  char pol_Typ;    //'V'-vertikalny  'H'-horizontalny
  int size;
  int size2;
  int void0_stock1;
  int m_map_A, m_map_B; //co uz nastavene aby to neprebil SetupVisual() defaultom
  
  bf_CSlider *posuv;       //slider na rolovanie
  bf_CButton *btnA, *btnB;  //tlacidla na alternativne scrolovanie
  bf_CIcon ipruh;        //dekoracny pruh pod sliderom
  
  //__declspec(dllexport) bf_CScrollBar();
  __declspec(dllexport) bf_CScrollBar( bf_CPosCHLO *parent, int iID );
  //__declspec(dllexport) virtual ~bf_CScrollBar();
  __declspec(dllexport) void Dsgn_Stock( char ttyp,  int rrx,int rry, int ssize );
  __declspec(dllexport) void Dsgn_Void(  char ttyp,  int rrx,int rry, int ssize1,int ssize2 );
  __declspec(dllexport) virtual int SetupVisual();

  __declspec(dllexport) virtual void GetSize( int *ssir, int *vvys );
  __declspec(dllexport) virtual void SetSize( int ssir, int vvys );
  
  __declspec(dllexport) virtual void DRAW( LPDIRECTDRAWSURFACE  d_SRF );

  //__declspec(dllexport) virtual bool CanDrag( int mx, int my ); //artikulacia uchopitelnosti dialogu
  //__declspec(dllexport) bool INFORM_SELF( int mx, int my, int mtlac );
  __declspec(dllexport) virtual bool HandleFWInteraction( int iID, int ivalue, bf_CPos *p_pol = NULL);
  
  //__declspec(dllexport) virtual void Parent_reset() { posuv->Parent_reset(); };
  __declspec(dllexport) void SR( int mmap_A, int mmap_B );  //SetRange
  __declspec(dllexport) void Pos_reset() { posuv->Pos_reset(); }; //reset pol. bezca
  __declspec(dllexport) void SP( int hod ) { posuv->SP( hod ); };  //SetPos
  __declspec(dllexport) int GP(){ return posuv->GP(); };    //GetPos
}; 

//=== DUI BEG ==============================================================

//------------------------------------------------------
// Typy=triedy DUI podla orientacie, rozlozenia volieb
//------------------------------------------------------
#define bf_c_DUI_class_0_FREE        0   //Volny styl (specificky rozlozene volby, bez zrejmeho pravidla)
#define bf_c_DUI_class_1_HORIZONTAL  1   //Menu styl  (do horizontalneho pruhu v hornej casti)
#define bf_c_DUI_class_2_VERTICAL    2   //Vyber styl  (do vertikalneho stlpca)
#define bf_c_DUI_class_3_TABULAR     3   //Tabulka/matica styl (do matice sir x vys);


class bf_CDUI;

//------------------------------------------------------
// element, polozka volby
//------------------------------------------------------
struct bf_TCHOICE
{   
  //zaklad:
  int   ID;     //ID vrateny pri aktivovani 
  RECT  rect;   //geometria volby - obalka (ohranicujuci obdlznik) 
  int   state;   //momentalny state (bez, vybrata, aktivovana)

  //veci okolo textu na volbe:
  LPSTR text;      //popis, 'label' volby
  bool text_owner; //ci je vlastnik textu (ci uvolnit "delete text" v destruktore)  
  int text_SIR, text_VYS;

  //veci okolo icony na volbe:
  bf_CIcon *p_icon;   //pointer na ikonu
  bool icon_owner;    //ci je vlastnik ikony (ci uvolnit "delete p_icon" v destruktore)  

  int  extra_duir_backup_mod;
  RECT extra_duir_backup_rect;
	
  bf_CDUI *Detail_dui_popup;   //podveseny "popup" dui (ak existuje)
  
  __declspec(dllexport) bf_TCHOICE();
  __declspec(dllexport) virtual ~bf_TCHOICE();
};

//------------------------------------------------------
// Objekt "DD User Interface" (rozhranie na vyber z postupnosti volieb)
//------------------------------------------------------
class bf_CDUI : public bf_CPos
{
private:
  int   vystup;      //interna informacia o aktualnm stave, o ID-ecku naposledy kliknutej volby (0,ID)

public:
  int trieda;       //0-free, volne; 1-horizontalny menu styl (ehm... zatial pevny pruh hore); 2-vertikalny vyber styl
  bool treba_RG;    //ci treba RESET_GEOMETRY (zmenili sa: trieda, konstanty, pocty poloziek, alebo poloha)
  int void_blend;   //status zablendovania inicializacnych void poloziek
  
  int   vystup_2;     //index vysvietenej volby (mys je prave nad nou)
  int   vystup_2_old; //pamat - vystup_2 z minulej informuj_sa akcie
  int   vystup_3;     //index novo nabehnutej volby (mys sa nad nu prave dostala)

  bool  disabled;

  LPDIRECTDRAWSURFACE  SRF_PTR;  //srf kam bude zobrazovany defaultne

  int     backgr_typ;   //0-bez  1-priesvitne(biele sito)  2-plne  3-priehladne(mliecne)
  RECT    backgr_rect;  //geometria podkladu, obalka
  int     LH,PH,HH,DH; //uzsia hranicna geometria (ako backgr_rect len zmensena prevazne o "d")
             //doplnene 6.1.10, vhodne pre orezanie icon

  HBRUSH  stet_vybr;   //stetec pre efekt vyberu volby (odporucene modry)
  HBRUSH  stet_aktiv;  //stetec pre efekt aktivacie volby (odporucene cerveny)
  HBRUSH  stet_popup;  //stetec pre efekt popup rozbalenia (odporucene zlty)
  HBRUSH  stet_podkl;  //stetec pre podklad (ak pokl_typ = 2)

  HPEN pero_ram_sed;   //pri level efekte (toolbar style)
  HPEN pero_vybr;      //na ohranicenie kazdej volby ramcom
  
  HFONT   font_hnd;
    //int     font_sir;
    //int     font_vys;

//-----------	
  bf_CARRE  VOL;    //hlavna struktura - polozky volieb (obsahuju pripadne aj texty a ikony)  //VOL(5,5, 2 );  //NODETACH
//-----------	

  //na auto-reset geometrie RESET_GEOMETRY(), resp. pre bf_CDUIR::RESET()
  int a; //vyska pruhov 
  int b; //rozostupy pruhov (vyska + medzera)
  int c; //sirka pruhov
  int d; //hrubka oramovania (urcuje podkladovy rect.)
  bool KOK;  //konstanty OK;
  int tab_m, tab_n;  //dimenzie pri triede tabular
  
  //int Width, Height;   //TODO: namiesto c,a ?
  int Border;   //pripadne oramovanie 
  
  char TextMode[2+1];
  int  TextPadding;
  char IconMode[2+1];
  int  IconPadding;

  int max_text_vys, max_text_sir;
  int max_icon_vys, max_icon_sir;
    
  int tr_x; int tr_y;  //eventualny relativny posun celeho DUI-vyber oproti default stredovej polohe
  int ta_x; int ta_y;  //eventualny absolutny posun (akcia len ked je nenulovy)

  //Pmod zavedeny na relativnu polohu s Posunom [Px,Py] //$ 30.7.03 
  int Pmod;
  int Px; int Py;
  //Z_mod zavedeny na Zoom/Zvacsenie senzitivnych poli pri vykreslovani
  bool Z_mod;
  int Z_sir; int Z_vys;
  //O_mod zavedeny na Oblenie rohov vybranej oblasti pri vykreslovani
  bool O_mod;
  int O_sir; int O_vys;

//bool Level_mod;  //ci volby s podfarbenim alebo s level efektom
  int  Select_mod; //ci volby: 1-s podfarbenim;  2-s level efektom;  3-aj aj
			
  bf_CDUI *Master_dui_popup;  //nadradeny "popup" dui (ak existuje)

  bool autohide;

  int count_force;  //ak nenulove tak prebije VOL.count pri nastaveni geometrie (default =0)
  static bool non_void_blend_mod;
  
  __declspec(dllexport) bf_CDUI();
  __declspec(dllexport) bf_CDUI( int ttrieda );
  __declspec(dllexport) bf_CDUI( char *iname );
  __declspec(dllexport) bf_CDUI( char *iname, int ttrieda );
  __declspec(dllexport) bf_CDUI( bf_CPosCHLO *parent, int irx, int iry );
  __declspec(dllexport) bf_CDUI( bf_CPosCHLO *parent, int iID );
   void Init(); 
  __declspec(dllexport) virtual void Compute_stats();
  __declspec(dllexport) void Init_KP();
  __declspec(dllexport) void RESET_DEFAULT();                //externe resetnutie do default podoby a polohy podla aktualnej triedy (a akt. poctu volieb)
  __declspec(dllexport) void RESET_DEFAULT( int ttrieda );   //externe resetnutie do default podoby a polohy podla zadanej triedy (a akt. poctu volieb)
  __declspec(dllexport) virtual ~bf_CDUI();

  __declspec(dllexport) void Set_Class( int ttrieda );
  __declspec(dllexport) void Set_Constants( int aa, int bb, int cc, int dd);
  __declspec(dllexport) virtual int Count();  //NOTE: je virtual, aby ked treba, sa spustila  bf_CDUIR:Count()
  
  __declspec(dllexport) virtual void GO_TO( int xx, int yy );   //NOTE: je virtual, aby ked treba, sa spustila  bf_CDUIR:GO_TO()
  __declspec(dllexport) virtual void GO_TO_CENTER( int xx, int yy );
  
  __declspec(dllexport) void         ADD( RECT *rrect, int IID, LPSTR ttext, bf_CIcon *p_iicon, bool iicon_owner );
  __declspec(dllexport) virtual void ADD(              int IID, LPSTR ttext, bf_CIcon *p_iicon, bool iicon_owner );
  __declspec(dllexport) virtual void ADD(              int IID, LPSTR ttext, bf_CIcon *p_iicon );
  __declspec(dllexport) virtual void ADD(              int IID, LPSTR ttext, LPSTR iicon_path );
  __declspec(dllexport) virtual void ADD(              int IID, LPSTR ttext );
 
  void FREE_i(int i);
  __declspec(dllexport) void REMOVE();  // Odoberie polozku z konca
  __declspec(dllexport) void DELETE_ALL();   // Anulovat, uvolnit polozky struktury 
  __declspec(dllexport) virtual void Join_Master_Detail_popup( int Mvolba, bf_CDUI *Ddui );
  
  __declspec(dllexport) void Compute_backgr_rect();
  __declspec(dllexport) void RESET_GEOMETRY();  
  
  void Level_efekt( HDC pDC, RECT *R, int state );
  __declspec(dllexport) void DRAW();
  __declspec(dllexport) void DRAW( LPDIRECTDRAWSURFACE  d_SRF );
  
  __declspec(dllexport) void SetTextMode( char *chch );
  __declspec(dllexport) void SetTextMode( int pos );
  __declspec(dllexport) void SetTextMode_NEXT();
  __declspec(dllexport) void SetIconMode( char *chch );
  __declspec(dllexport) void SetIconMode( int pos );
  __declspec(dllexport) void SetIconMode_NEXT();
  void SetMode( char *Mode, char *chch );
  void SetMode_EN( char *Mode, int pos );
  void SetMode_NEXT_EN( char *Mode );
  
  __declspec(dllexport) virtual void GetSize( int *ssir, int *vvys );
  //__declspec(dllexport) virtual void SetSize( int ssir, int vvys );  //TODO
  __declspec(dllexport) bool test_in_rect( RECT rc, int xx, int yy );
  __declspec(dllexport) bool INFORM_SELF( int mx, int my, int mtlac );
  void visible_off_popup_recursive();
  __declspec(dllexport) bool INFORM_ME( int *vvystup );
  __declspec(dllexport) bool INFORM_ME_3( int *ind, int *hod );
  
  __declspec(dllexport) void Dsgn( int rrx,int rry );
  __declspec(dllexport) void SetFont(int height, int width, int weight, LPCSTR facename);

  __declspec(dllexport) virtual void Parent_reset() { bf_CPos::Parent_reset(); treba_RG = true; };
};

bool bf_CDUI::non_void_blend_mod = false;    //default doplnat 3x void volby, default chceme tie 3 void tam mat

//=== DUI END ==================================================================


//================================================ DUIR_* ==========================================================

//------------------------------------------------------
//------------------------------------------------------
struct bf_TCHOICER
{   
	  int   ID;     //ID vrateny pri aktivovani 

	  LPSTR text;   //popis, 'label' volby 
	  bool text_owner; //ci je vlastnik textu (ci uvolnit "delete text" v destruktore)  
	  int text_SIR, text_VYS;
	
    bf_CIcon *p_icon; //pointer na ikonu
    bool icon_owner;  //ci je vlastnik ikony (ci uvolnit "delete p_icon" v destruktore)  
	
	  bf_CDUI *Detail_dui_popup;   //podveseny "popup" dui (ak existuje)
	
    void *data;           //pomocny smernik na buduce vyzitie (napr. bf_UTL_CDUIR_THMFILE tam uklada cestu ako char*)
                          //bacha: treba pri pristupe pretypovat a nezabudnut uvolnovat! (lebo DUIR nevie, co tam vlastne visi)
						  
    __declspec(dllexport) bf_TCHOICER();
    __declspec(dllexport) virtual ~bf_TCHOICER();
};

//------------------------------------------------------
// Objekt "DD User Interface Rollable" (rolovatelne rozhranie na vyber z postupnosti volieb)
// ak pocet prvkov volieb prekroci definovany limit, objavi sa posuvnik/slider umoznujuci rolovanie
//------------------------------------------------------
class bf_CDUIR : public bf_CDUI
{
public:
    bool treba_RGR;   //ci treba RESET_GEOMETRY (zmenili sa: trieda, konstanty, poloha, pocty poloziek, alebo Rol pos.)
	int void_blendR;  //status zablendovania inicializacnych voidr poloziek
	
	bf_CSlider posuv_;    //slider na rolovanie
 	bf_CButton tlacA_, tlacB_;  //horne a dolne tlacidlo
	bf_CIcon ipruh_;     //dekoracny pruh pod sliderom

  bool Rol_mod;     //ci je aktivovany rol mod	
  int Rol_poc_zobr; //kolko max. je plne(!) zobrazitelnych naraz (ak nepresiahneme v VOLR.count, netreba ani rolovatka )  
  int Rol_pos;      //poloha v rol priestore 
  int Rol_max;      //maximalna poloha 

  bool Keep_Last;	  //mod, ked chceme byt vzdy scrolnuty naspodku (dvojice/relacie napr. pouzivaju)

  //-----------	
	bf_CARRE  VOLR;      //hlavna struktura - polozky volieb
  //-----------	
  
	__declspec(dllexport) bf_CDUIR();
	__declspec(dllexport) bf_CDUIR( char *iname );
  __declspec(dllexport) bf_CDUIR( bf_CPosCHLO *parent, int irx, int iry );
  __declspec(dllexport) bf_CDUIR( bf_CPosCHLO *parent, int iID );
	void InitR();
  __declspec(dllexport) virtual ~bf_CDUIR();
	
  __declspec(dllexport) void Compute_stats();
  __declspec(dllexport) void Compute_statsR();
  __declspec(dllexport) int Count();
	__declspec(dllexport) int CountR();

	__declspec(dllexport) void GO_TO ( int xx, int yy );
  __declspec(dllexport) void GO_TOR( int xx, int yy );
  __declspec(dllexport) void GO_TO_CENTER ( int xx, int yy );
  __declspec(dllexport) void GO_TO_CENTERR( int xx, int yy );
	
	// Pridat polozku na koniec
	__declspec(dllexport) void ADD (      int IID, LPSTR ttext, bf_CIcon *p_iicon, bool iicon_owner );
  __declspec(dllexport) void ADD (      int IID, LPSTR ttext, bf_CIcon *p_iicon );
	__declspec(dllexport) void ADD (      int IID, LPSTR ttext, LPSTR iicon_path );
  __declspec(dllexport) void ADD (      int IID, LPSTR ttext );
  //__declspec(dllexport) void ADDR(      int IID, LPSTR ttext, bf_CIcon *p_iicon, bool iicon_owner );
	__declspec(dllexport) bf_TCHOICER* ADDR( int IID, LPSTR ttext, bf_CIcon *p_iicon, bool iicon_owner );
	 	
	void FREER_i(int i);
	__declspec(dllexport) void REMOVE();   // Odoberie polozku z konca
  __declspec(dllexport) void REMOVER();  // Odoberie polozku z konca
	__declspec(dllexport) void DELETE_ALL();    // Anulovat, uvolnit polozky struktury 
  __declspec(dllexport) void DELETE_ALLR();   // Anulovat, uvolnit polozky struktury 
	
	__declspec(dllexport) void Join_Master_Detail_popup( int Mvolba, bf_CDUI *Ddui );
	__declspec(dllexport) void Join_Master_Detail_popupR( int Mvolba, bf_CDUI *Ddui );
	__declspec(dllexport) void Join_Master_Detail_popupR__indexovo( int index, bf_CDUI *Ddui );
	__declspec(dllexport) bf_TCHOICER * operator[]( int index );              // Vratit smernik na volbu indexovo
  __declspec(dllexport) bf_TCHOICER * VratVolbu__indexovo( int index );     // Vratit smernik na volbu indexovo
  __declspec(dllexport) bf_TCHOICER * VratVolbu__hodnotovo( int hodnota );  // Vratit smernik na volbu hodnotovo
  __declspec(dllexport) bf_TCHOICER * VratVolbu__podla_textu( LPSTR ttext );  // Vratit smernik na volbu podla textu
	
  __declspec(dllexport) void RESET_GEOMETRY();
	__declspec(dllexport) void RESET_GEOMETRYR();
	
	__declspec(dllexport) virtual void Parent_reset() { bf_CPos::Parent_reset(); treba_RGR = true; };

private:	
	//void RESET( int pos );
	//pomocne
    void Preklop( int jj, int ii, RECT *rr, RECT *eduirb_rect = NULL, int eduirb_mod = 0 );
    bool Orez_HD( RECT *rrect );

public:
	__declspec(dllexport) void DRAW();
	__declspec(dllexport) void DRAW( LPDIRECTDRAWSURFACE  d_SRF );
	__declspec(dllexport) void DRAWR( LPDIRECTDRAWSURFACE  d_SRF );
	__declspec(dllexport) bool INFORM_SELF( int mx, int my, int mtlac );
};


//================================================ bf_DSO_* ==========================================================

//static LPDIRECTSOUND         lpDS;
//LPDIRECTSOUNDBUFFER   je zapuzdreny v triede bf_CDSO_Zvuk

bool bf_DSO_ONOFF = true;  //Globalka na externe zapnutie / vypnutie

//ci robit ladiace vypisy do logu bf_DSO_INFO.txt
//static BOOL bf_DSO_lad_info_zap = FALSE;
//BOOL bf_DSO_lad_info_zap = TRUE;

//-------------------------------
// Info
//-------------------------------
//extern "C" __declspec(dllexport) void bf_DSO_INFO( char *text );
//extern "C" __declspec(dllexport) void bf_DSO_INFO( char *text, LPSTR nazov );

//-------------------------------
//Deinicializacia
//-------------------------------
extern "C" __declspec(dllexport) BOOL bf_DSO_DONE( void );

//-------------------------------  //DSO
//Initializacia
//-------------------------------
extern "C" __declspec(dllexport) BOOL bf_DSO_INIT( HWND hwnd );

//------------------------------------------------------
//------------------------------------------------------
class bf_CDSO_Zvuk
{
public:
   LPSTR  res_nazov;           // nazov wav resource
   LPSTR  subor_nazov;         // nazov wav suboru

   LPDIRECTSOUNDBUFFER SBUFFER;   //fyzicky bufer zvuku

   __declspec(dllexport) bf_CDSO_Zvuk();
   __declspec(dllexport) virtual ~bf_CDSO_Zvuk();

   __declspec(dllexport) void ODSTRAN();
   __declspec(dllexport) BOOL NAHRAJ_RES( LPSTR p_nazov );
   __declspec(dllexport) BOOL NAHRAJ_FILE( LPSTR p_nazov );
   __declspec(dllexport) BOOL NAHRAJ( LPSTR p_nazov );
   
   __declspec(dllexport) BOOL SPUSTI();
};


//================================================ bf_BMP_* ==========================================================

//----------------------------------------------------------------
// Pom. logovanie
//----------------------------------------------------------------
//void bf_BMP_LOG( char * info );

//----------------------------------------------------------------
// pomocna pri stretch kalkulacii novych rozmerov ciela
//----------------------------------------------------------------
extern "C" __declspec(dllexport) 
void bf_BMP_NOVE_ROZMERY
                      ( int sir, int vys,
                        int koef, int FIXMAX_sir, int FIXMAX_vys,
                        int *sir2_new, int *vys2_new
                      );

//----------------------------------------------------------------
// Jadro na vytvaranie .bmp:
// zo surface p_lpDDSURFACE vyreze obdlznik p_R a ulozi to ako bitmapu p_filename_out
//----------------------------------------------------------------
extern "C" __declspec(dllexport) 
void bf_BMP_VYTVOR_BMP_0_zoSRF_doFILE
            ( LPDIRECTDRAWSURFACE p_lpDDSURFACE,
              RECT p_R,
              char *p_filename_out
            );

//----------------------------------------------------------------
// Cely SRF do FILE
//----------------------------------------------------------------
extern "C" __declspec(dllexport) 
void bf_BMP_VYTVOR_BMP_0_celySRF_doFILE
                   (  LPDIRECTDRAWSURFACE p_lpDDSURFACE,
                      char *p_filename_out
                    );

//----------------------------------------------------------------
//Zmensi, spravi stretch z raw srf a ulozi do bmp suboru
//Zdrojom je raw surface, nie subor!  Vhodne na scan obrazovky
//- upravi na maximalny ramec [FIXMAX_sir x FIXMAX_vys]
//- proporc urcuje, ci sa ma brat FIXMAX_* formalne (vojst sa "do" ale zachovat 
//  proporcie in srf) alebo absolutne  
//----------------------------------------------------------------
extern "C" __declspec(dllexport) 
void bf_BMP_VYTVOR_BMP_0_zoSRF_doFILE__stretch
            ( LPDIRECTDRAW p_lpDD,
              LPDIRECTDRAWSURFACE p_lpDDSURFACE_in,
              bool proporc, int FIXMAX_sir, int FIXMAX_vys,
              char *p_filename_out
            );

//----------------------------------------------------------------
// Len kopia (vznikne 24bit bmp 1:1)
//----------------------------------------------------------------
extern "C" __declspec(dllexport) 
void bf_BMP_VYTVOR_BMP_2_zFILE_doFILE__copy_cezSRF
          ( LPDIRECTDRAW p_lpDD, 
            char *p_filename_in, 
            char *p_filename_out 
          );

//----------------------------------------------------------------
//Proporcialne zmensi, spravi stretch a ulozi do bmp suboru:
//----------------------------------------------------------------

//- bud zmensi koef-krat 
//- alebo (ak koef=0) upravi na maximalny ramec [FIXMAX_sir x FIXMAX_vys]
extern "C" __declspec(dllexport) 
void bf_BMP_VYTVOR_BMP_3_zFILE_doFILE__stretch_cezSRF
            ( LPDIRECTDRAW p_lpDD, 
              char *p_filename_in,
              int koef, int FIXMAX_sir, int FIXMAX_vys,
              char *p_filename_out
            );
            
//Alternativna 3B
extern "C" __declspec(dllexport) 
void bf_BMP_VYTVOR_BMP_3B_zFILE_doFILE__stretch_cezSRF
                      ( LPDIRECTDRAW p_lpDD, 
                        char *p_filename_in,
                        int fix_sir, int fix_vys,
                        char *p_filename_out
                      );
                      
//Alternativna 3C
extern "C" __declspec(dllexport) 
void bf_BMP_VYTVOR_BMP_3C_zFILE_doFILE__stretch_cezSRF
                      ( LPDIRECTDRAW p_lpDD, 
                        char *p_filename_in,
                        int base_sir, int base_vys,
                        float koef_vys_od, float koef_vys_po,
                        char *p_filename_out
                      );

//----------------------------------------------------------------
//Proporcialne zmensi, spravi stretch ale len z jedinej fazy,
//upravi ju na maximalny ramec [FIXMAX_sir x FIXMAX_vys] a ulozi do bmp suboru
//----------------------------------------------------------------
extern "C" __declspec(dllexport) 
void bf_BMP_VYTVOR_BMP_4_zFILE_doFILE__stretch_FAZA_cezSRF
            ( LPDIRECTDRAW p_lpDD, 
              char *p_filename_in,
              int FIXMAX_sir, int FIXMAX_vys,
              char *p_filename_out,
              int fx, int fy
            );

//----------------------------------------------------------------
// Prejde zadany adresar a pre kazdu .bmp vytvori .thm s danymi rozmermi a vrati ich zoznam v poli
//(stare, koli kompatibilite)
//----------------------------------------------------------------
extern "C" __declspec(dllexport) 
int bf_BMP_Zisti_Vytvor__bmp2thm(char *INAdresar, bool scestou, 
                 LPDIRECTDRAW p_lpDD, int sir, int vys, 
                 LPSTR *out_nazvy, int *out_maxid );
                 
//----------------------------------------------------------------
// Prejde zadany adresar a pre kazdu .bmp vytvori .thm s danymi rozmermi a vrati ich zoznam v poli
// verzia s3C rutinou - vyrezanie vertikalne s koeficientmi (pevne 0.25, 0.75, co je fajn pre nahlady sferickych fotografii)
//(stare, koli kompatibilite)
//----------------------------------------------------------------
extern "C" __declspec(dllexport) 
int bf_BMP_Zisti_Vytvor__bmp2thm_s3C(char *INAdresar, bool scestou, 
                 LPDIRECTDRAW p_lpDD, int sir, int vys, 
                 LPSTR *out_nazvy, int *out_maxid );

//----------------------------------------------------------------
// Prejde zadany adresar a pre kazdu .bmp vytvori .thm s danymi rozmermi
// - nic nevracia
// - mod specifikuje ako sa thm vytvori
//(NOVE)
//----------------------------------------------------------------
extern "C" __declspec(dllexport) 
int bf_BMP_Vytvor__bmp2thm( char *INAdresar, int sir, int vys, int mod = 1 );
				 
//============================================== BF_FSI_* ===================================================

//----------------------------------------------------------------
// Vystrihne samotnu cestu k suboru (vrati retazec od zaciatku po posledne lomitko, vcetne)
// NOTE: vystupny bufer p_meno-> musi byt alokovany pred volanim!
//----------------------------------------------------------------
//extern "C" __declspec(dllexport)
//void bf_FSI_Vystrihni_cestu_bez_mena( char *p_sub, char *p_cesta );

//----------------------------------------------------------------
// Vystrihne meno suboru bez pripony (vrati retazec medzi poslednym lomitkom a bodkou)
// NOTE: vystupny bufer p_meno-> musi byt alokovany pred volanim!
//----------------------------------------------------------------
extern "C" __declspec(dllexport)
void bf_FSI_Vystrihni_meno( char *p_sub, char *p_meno );

//----------------------------------------------------------------
// Odstrihne meno suboru/adresara (vrati retazec za poslednym lomitkom)
// NOTE: vystupny bufer p_meno-> musi byt alokovany pred volanim!
//----------------------------------------------------------------
extern "C" __declspec(dllexport)
void bf_FSI_Odstrihni_meno( char *p_sub, char *p_meno );

//----------------------------------------------------------------
// Zameni priponu
// NOTE: vystupny bufer p_sub_out-> musi byt alokovany pred volanim! 
// Pr.: bf_BMP_Zmen_priponu( cesta_subor, "thm", cesta_subor_thm )
//----------------------------------------------------------------
extern "C" __declspec(dllexport) 
void bf_FSI_Zmen_priponu( char *p_sub, char *p_prip, char *p_sub_out );

//----------------------------------------------------------------
// Ci existuje subor
//----------------------------------------------------------------
extern "C" __declspec(dllexport) 
bool bf_FSI_Existuje_sub( char *p_sub );

//----------------------------------------------------------------
// Vymazat subor
//----------------------------------------------------------------
extern "C" __declspec(dllexport) 
void bf_FSI_Vymaz_sub( char *p_sub );

//----------------------------------------------------------------
// Prejde zadany adresar a vrati maske vyhovujuce podadresare alebo subory
// vracia zoznam v poli
//  subadr = 0 ... hladame len subory
//  subadr = 1 ... hladame len adresare
//----------------------------------------------------------------
//stara verzia (nepublikujem)
int bf_FSI_Zisti_SubAdr(char *INAdresar, char *maska, unsigned subadr, bool scestou, LPSTR *out_nazvy, int *out_maxid );
//nova verzia
extern "C" __declspec(dllexport) 
int bf_FSI_Zisti_SubAdr(char *INAdresar, char *maska, unsigned subadr, bool scestou, bf_CARRE *out_nazvy );

//----------------------------------------------------------------
// Preveri existenciu foldra
//----------------------------------------------------------------
extern "C" __declspec(dllexport) 
bool bf_FSI_ExistsFolder( char *IN_cesta_folder );

//----------------------------------------------------------------
// Rekurzivny report o adresarovej strukture a suboroch
// NOTE: Predpokladam zadanu cestu k foldru bez lomitka na konci
//----------------------------------------------------------------
extern "C" __declspec(dllexport) 
int bf_FSI_ListFolder( char *IN_cesta_folder );
			
//----------------------------------------------------------------
// Rekurzivna synchronizacia adresarovej struktury a suborov
// NOTE: - oba foldre musia existovat, 
//       - vlastne sa skopiruje obsah z prveho do druheho foldra: (COPY A => B)
//       - predpokladam zadanu cestu k foldru bez lomitka na konci
//----------------------------------------------------------------
extern "C" __declspec(dllexport) 
int bf_FSI_SynchroFolders( char *IN_cesta_folder_A, char *IN_cesta_folder_B );
			


//================================================ BF_DFO_w ==========================================================

//------------------------------------------------------
//------------------------------------------------------
class bf_CFolia : public bf_CPos
{
public:
  __declspec(dllexport) void DRAW_NA( LPDIRECTDRAWSURFACE d_SRF, int LH_x, int LH_y );
};

//------------------------------------------------------
//------------------------------------------------------
struct bf_TPOL_FoliaText
{   
	LPSTR text;   //popis, 'label'
	int   rx,ry;  //relativna poloha textu voci LH
};

//------------------------------------------------------
//------------------------------------------------------
class bf_CFoliaText : public bf_CFolia //bf_CPos
{
public:
  //bf_TPOL_FoliaText TP[25]; //texty-polozky (fixne ponate)
  bf_TPOL_FoliaText * FTP;     //len smernik (dynamicky ponate) Folia Text Polozky
  int FTP_pocet;
  int FTP_max_pocet;

  COLORREF CR_farba_prvy;   //prvy riadok - farba
  COLORREF CR_farba_text;   //ostatne riadky - farba

  __declspec(dllexport) bf_CFoliaText();
  __declspec(dllexport) virtual ~bf_CFoliaText();
  __declspec(dllexport) void ALOKUJ( int N );
//void DELETE_ALL();
  __declspec(dllexport) void ADD( LPSTR ttext, int rxx, int ryy );
  __declspec(dllexport) void RESET( int ind, int rxx, int ryy );
  __declspec(dllexport) void DRAW( LPDIRECTDRAWSURFACE d_SRF );  
};

//------------------------------------------------------
//------------------------------------------------------
struct bf_TPOL_FoliaFaz
{   
	bf_TPHASE faza; //faza (cela instancia, nie referencia )
	int   rx,ry;   //relativna poloha umiestnenia fazy voci LH
};

//------------------------------------------------------
//------------------------------------------------------
class bf_CFoliaFaz : public bf_CFolia //bf_CPos
{
public:
  bf_CDas_Surface *Das_Surface; 

  bf_TPOL_FoliaFaz * FFP;    //len smernik (dynamicky ponate)  Folia Faz Polozky
  int FFP_pocet;
  int FFP_max_pocet;

  int def_inic_x, def_inic_y;  //def_inic_deltax, def_inic_deltay; //dafault (pred znamostou vyslednej polohy) 
  
  __declspec(dllexport) bf_CFoliaFaz();
  __declspec(dllexport) virtual ~bf_CFoliaFaz();
  __declspec(dllexport) void ALOKUJ( int N );
//void DELETE_ALL();
  __declspec(dllexport) void ADD( int fxx, int fyy,  int rxx, int ryy );
  __declspec(dllexport) void ADD( int fxx, int fyy );
  __declspec(dllexport) void DRAW( LPDIRECTDRAWSURFACE d_SRF ); // { DRAW( d_SRF, x, y ) };  
};

//------------------------------------------------------
//------------------------------------------------------
struct bf_TPOL_FoliaIcon
{   
    bf_CIcon icon;  //ikona (cela instancia, nie referencia )
	int   rx,ry;    //relativna poloha umiestnenia fazy voci LH
};

//------------------------------------------------------
//------------------------------------------------------
class bf_CFoliaIcon : public bf_CFolia //bf_CPos
{
public:
  bf_TPOL_FoliaIcon * FIP;    //len smernik (dynamicky ponate)  Folia Icon Polozky
  int FIP_pocet;
  int FIP_max_pocet;

  int def_inic_x, def_inic_y;  //, def_inic_deltax, def_inic_deltay; //dafault (pred znamostou vyslednej polohy) 
  
  __declspec(dllexport) bf_CFoliaIcon();
  __declspec(dllexport) virtual ~bf_CFoliaIcon();
  __declspec(dllexport) void ALOKUJ( int N );

  __declspec(dllexport) void ADD( bf_CDas_Surface *p_memSRF, int fxx, int fyy,  int rxx, int ryy );  //zamera ikonu s fazou v bode [fxx,fyy] a s rel sur. [rxx,ryy]
  __declspec(dllexport) void ADD( bf_CDas_Surface *p_memSRF, int fxx, int fyy );
  __declspec(dllexport) void RESET( int ind, int rxx, int ryy );
  __declspec(dllexport) void DRAW( LPDIRECTDRAWSURFACE d_SRF );  
};

//------------------------------------------------------
//------------------------------------------------------
struct bf_TPOL_FoliaDekor
{   
	char  typ;     //H-ciara, V-ciara, R-Rect
	int   rx,ry;   //relativna poloha umiestnenia fazy voci LH
	int   dx,dy;   //dimenzie - sir,vys
};

//------------------------------------------------------
//------------------------------------------------------
class bf_CFoliaDekor : public bf_CFolia //bf_CPos
{
public:
  bf_TPOL_FoliaDekor * FDP;    //len smernik (dynamicky ponate)
  int FDP_pocet;
  int FDP_max_pocet;

  int def_inic_x, def_inic_y;  //, def_inic_deltax, def_inic_deltay; //dafault (pred znamostou vyslednej polohy) 
  
  HPEN FD_pero_ram_b;
  HPEN FD_pero_ram_s1;
  HPEN FD_pero_ram_s2;
  HPEN FD_pero_ram_s3;
  
  __declspec(dllexport) bf_CFoliaDekor();
  __declspec(dllexport) virtual ~bf_CFoliaDekor();
  __declspec(dllexport) void ALOKUJ( int N );

  __declspec(dllexport) void ADD( char ttyp, int rxx, int ryy, int dxx, int dyy );
  __declspec(dllexport) void ADD( char ttyp, int rxx, int ryy, int DD );
//__declspec(dllexport) void ADD( char ttyp, int dxx, int dyy );
  __declspec(dllexport) void RESET( int ind, char ttyp, int rxx, int ryy, int dxx, int dyy );
  __declspec(dllexport) void RESET( int ind, char ttyp, int rxx, int ryy, int DD );
  
  __declspec(dllexport) void FD_H_ciara( HDC pDC, int xx1, int xx2, int yy, int mmod );
  __declspec(dllexport) void DRAW( LPDIRECTDRAWSURFACE d_SRF );
};

//================================================ bf_UTL =====================================================

//------------------------------------------------------
// DUIR s graf. subormi a s ich ikonami (thm)  
//------------------------------------------------------
class bf_UTL_CDUIR_THMFILE : public bf_CDUIR
{
public:
  int thm_sir, thm_vys;   //rozmery thm (thumb. icon), ak sa thm vytvaraju, tak budu taketo
  
  void Init();
  __declspec(dllexport) bf_UTL_CDUIR_THMFILE();
  __declspec(dllexport) bf_UTL_CDUIR_THMFILE( char *iname );
  __declspec(dllexport) bf_UTL_CDUIR_THMFILE( bf_CPosCHLO *parent, int irx, int iry );
  __declspec(dllexport) bf_UTL_CDUIR_THMFILE( bf_CPosCHLO *parent, int iID );
  __declspec(dllexport) virtual ~bf_UTL_CDUIR_THMFILE();
  
  // Anulovat, uvolnit polozky struktury  
  void DELETE_ALLR_THMFILE();
  
  // Pridat novu polozku do struktury aj s odlozenim plnej cesty k hlavnemu suboru (ffile_path) do (data->)
  void ADD_THMFILE( int IID, LPSTR ttext, LPSTR iicon_path, LPSTR ffile_path );
  
  // Nahra obsah priecinka (len "append" - nezistuje co tam uz je)
  __declspec(dllexport) int LOAD( char *folderpath, bool default_transpar =true );
  // Resetne povodny obsah DUIR + nahra znova obsah priecinka
  __declspec(dllexport) int RELOAD( char *folderpath, bool default_transpar ); //= true
  // Doplni THM + Resetne povodny obsah DUIR + nahra znova obsah priecinka + prisposobi geometriu ikonam
  __declspec(dllexport) int XRELOAD( char *folderpath, bool default_transpar ); //=true
  
  // Statistika nad THM ikonami: prejde cez ikony vsetkych volieb a zisti maxima a minima ich rozmerov
  __declspec(dllexport) int GetIconsStatistics( int *MINsir, int *MAXsir, int *MINvys, int *MAXvys );
  // Resetne geometriu (zmena rozmerov poloziek i celeho DUIR) podla THM ikon
  __declspec(dllexport) int AUTORESIZE();
};

//------------------------------------------------------
// DUIR s adresarmi (zlozkami)
//------------------------------------------------------
class bf_UTL_CDUIR_DIR : public bf_CDUIR
{
public:
  void Init();
  __declspec(dllexport) bf_UTL_CDUIR_DIR();
  __declspec(dllexport) bf_UTL_CDUIR_DIR( char *iname );
  __declspec(dllexport) bf_UTL_CDUIR_DIR( bf_CPosCHLO *parent, int irx, int iry );
  __declspec(dllexport) bf_UTL_CDUIR_DIR( bf_CPosCHLO *parent, int iID  );
  __declspec(dllexport) ~bf_UTL_CDUIR_DIR();

  // Pridat novu polozku do struktury aj s odlozenim plnej cesty k hlavnemu suboru (ffile_path) do (data->)
  // - speci "nadobicko" pre tohoto UTL odvodenca
  __declspec(dllexport) void ADD_DIR( int IID, LPSTR ttext, LPSTR ddir_path );

  // Nahra podadresare daneho adresara s danou maskou (len "append" - nezistuje co tam uz je)
  // folderpath - cesta do nadadresara
  __declspec(dllexport) int LOAD( char *ffolderpath, char *ddirlike );
  // mmaxlevel - max. pocet rekurentnych vynoreni pri hladani
  __declspec(dllexport) int LOAD(char *ddirlike, int mmaxlevel);
};


//------------------------------------------------------
const int IDC_UTL_DLG_EDIT_OK    = -10101;
const int IDC_UTL_DLG_EDIT_ZRUS  = -10102;
const int IDC_UTL_DLG_EDIT_ZRUSx = -10103;
const int IDL_UTL_DLG_EDIT_OK    = -10104;
const int IDL_UTL_DLG_EDIT_ZRUS  = -10105;

//------------------------------------------------------
// Dialog s edit polom
//------------------------------------------------------
class bf_UTL_CDLG_EDIT : public bf_CDialog 
{
public:
	char ch_title[100];
	char ch_prompt[100];

    bf_CLabel *title;
	bf_CLabel *prompt; 
	
	bf_CPosIcon *quest_icon;
	bf_CPosIcon *ok_icon, *cancel_icon;
	
	bf_CEDB *edb;
    bf_CButton *btnOK; 
    bf_CButton *btnCancel;
	bf_CButton *T_x;

    __declspec(dllexport) bf_UTL_CDLG_EDIT( bf_CPosCHLO *parent, char *ttitle, char *pprompt );
	__declspec(dllexport) virtual int SetupVisual();
	__declspec(dllexport) char * Get_Text();
	bool HandleFWInteraction( int iID, int ivalue, bf_CPos *p_pol = NULL);	
};

//============================================== bf_DSGN ====================================================

bool bf_DSGN_INIT_flag = false;      //indikacia nahratia
//bf_CDas_Surface   bf_DSGN_rezia_dll_srf( "bf_DSGN_rezia_dll_srf" );
//bf_CDas_Surface  *bf_DSGN_rezia_dll_srf;
//bf_CIcon         *bf_DSGN_question_icon;

struct bf_DSGN_Struct
{   
   bf_CDas_Surface  *background_srf;
   bf_CDas_Surface  *rezia_dll_srf;
   
   bf_CButton  *_T_x_;   
   
   bf_CIcon *_logo_bonbliot_;
   bf_CIcon *_void_icon_;
      
   bf_CIcon  *_question_icon_;
   bf_CIcon  *_ok_icon_, *_cancel_icon_;
   
   bf_CSlider *_posuvV_;                          //slider vertikalny na rolovanie
   bf_CButton  *_posuvV_btnA_, *_posuvV_btnB_;     //horne a dolne tlacidlo vertik. posuvn
   bf_CIcon  _posuvV_ipruh_;                     //dekoracny pruh pod vertik. sliderom
   bf_CSlider *_posuvH_;                          //slider horizontalny na rolovanie
   bf_CButton  *_posuvH_btnA_, *_posuvH_btnB_;     //lave a prave tlacidlo vertik. posuvn
   bf_CIcon   _posuvH_ipruh_;                    //dekoracny pruh pod horizont. sliderom	  
	  
   bf_CSlider *_posuvV2_;                         //slider vertikalny 2
   bf_CSlider *_posuvH2_;                         //slider horizontalny 2

   bf_CSwitch *_check_;
   bf_CSwitch *_radio_;

   HFONT  _font_hnd_Labels_1;
   HFONT  _font_hnd_Labels_2;

   HPEN pero_ram_b, /*pero_ram_s1,*/ pero_ram_s2, pero_ram_s3;

   bf_DSGN_Struct() 
   {   
     background_srf = NULL;
     rezia_dll_srf = NULL;
	   _T_x_ = NULL;
	   _logo_bonbliot_ = NULL;
	   _question_icon_ = NULL;
	   _ok_icon_ = NULL; _cancel_icon_ = NULL;
	   _posuvV_ = NULL;
	   _posuvV_btnA_ = NULL; _posuvV_btnB_ = NULL;
	   _posuvH_ = NULL;
	   _posuvH_btnA_ = NULL; _posuvH_btnB_ = NULL;
	   _posuvV2_ = NULL;
	   _posuvH2_ = NULL;
     _check_ = NULL;
     _radio_ = NULL;
	   _font_hnd_Labels_1 = NULL;
     _font_hnd_Labels_2 = NULL;
     pero_ram_b = NULL; /*pero_ram_s1 = NULL;*/ pero_ram_s2 = NULL; pero_ram_s3 = NULL;
   };
}; //bf_DSGN;

//bf_DSGN_Struct  bf_DSGN;    //presun do DBonbliotFW_priv.h

//-------------------------------
__declspec(dllexport) HFONT bf_DSGN_CreateFont(int height, int width, int weight, LPCSTR facename);
__declspec(dllexport) void bf_DSGN_SetLabelsDefaultFont(int height, int width, int weight, LPCSTR facename);

//-------------------------------
//Initializacia
//-------------------------------
//extern "C" 
__declspec(dllexport) BOOL bf_DSGN_INIT();

//-------------------------------
//Deinicializacia
//-------------------------------
//extern "C"
__declspec(dllexport) BOOL bf_DSGN_DONE();

//============================================== BF_KM_* ===================================================
  
  //konstanty modov
  #define bf_KM_cNO_0    0
  
  #define bf_KM_cDUI_1   1
  #define bf_KM_cDUIR_2  2 
  
  #define bf_KM_cFT_3    3
  #define bf_KM_cFF_4    4
  #define bf_KM_cFI_5    5
  #define bf_KM_cFD_6    6 
  
  #define bf_KM_cDE_7    7 
  #define bf_KM_cDLG_8   8
  
  #define bf_KM_cPolCHLO_9  9
  #define bf_KM_cPol_10  10
  
  //mapovatelne premenne
  bf_CDUI       *bf_KM_pDUI = NULL;
  bf_CDUIR      *bf_KM_pDUIR = NULL;
  
  bf_CFoliaText *bf_KM_pFT  = NULL;
  bf_CFoliaFaz  *bf_KM_pFF  = NULL;
  bf_CFoliaIcon *bf_KM_pFI  = NULL;
  bf_CFoliaDekor *bf_KM_pFD = NULL;
  
  bf_CDialog_EFFECT *bf_KM_pDE = NULL;
  bf_CDialog   *bf_KM_pDLG = NULL;

  bf_CPosCHLO   *bf_KM_pPolCHLO = NULL;
  bf_CPos       *bf_KM_pPol     = NULL;
   
  //bool bf_KM_ZAP = true; 
  bool bf_KM_ZAP = false; 
  int  bf_KM_mod = 0;
			  
                  //OLD!!!!!:
                  //* 0 nic=ostry rezim
                  //  -- 
                  //* 1 prvky text-folie
                  //  --
                  //* 2 telo dialogu 
                  //* 3 prvky dialogu (CHL)
                  //  --
                  //* 4 polozky DUI
                  //* 5 telo, obalka DUI
                  //  --
                  //* 6 prvky faz-folie tvare polozene v dialogu
				  //  --
				  //* 7 dialog efekt
  

//-------------------------------
// Zapnut/vypnut cez hlavny vypinac (bf_KM_ZAP)
//-------------------------------
//void bf_KM_ONOFF();

//-------------------------------
// Spracovanie udalosti vseobecne
//-------------------------------
extern "C" __declspec(dllexport) 
void bf_KM_WindowProc( HWND hWnd, UINT message, 
                       WPARAM wParam, LPARAM lParam );

//-------------------------------
// Vykresli zameranie / focus manipulovaneho prvku
//-------------------------------
//void bf_KM_DRAW( LPDIRECTDRAWSURFACE d_SRF, int DLH_x, int DLH_y );
extern "C" __declspec(dllexport) 
void bf_KM_DRAW( LPDIRECTDRAWSURFACE d_SRF );

//-------------------------------
// Ulozi, odchyti novu geometriu manipulovanych prvkov do subora "bf_KM_report.txt"
//-------------------------------
extern "C" __declspec(dllexport) 
void bf_KM_SAVE();

//================================================ bf_APP ==========================================================
__declspec(dllexport) HWND bf_Get_APP_hWnd_GLOB();

class bf_CAppScreen;

//presun do private headra DBonbliotFW_priv.h
//bf_CAppScreen *bf_APP_pRAS_GLOB = NULL;  //Running AppScreen Global
//HWND           bf_APP_hWnd_GLOB = NULL;  //Handle on Window Global

// Interne globalne fcie:
//long FAR PASCAL bf_APP_WindowProc( HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam );
//void            bf_APP_FINITO( HWND p_hWnd );
//static void     bf_APP_Vykonaj_RELEASE_SRF( bool aj_DD = true );
//static HRESULT  bf_APP_Vykonaj_RESTORE_SRF();
//static void     bf_APP_Vykonaj_RELOAD_SRF();
//void            bf_APP_Prekresli_scenu();
//BOOL            bf_APP_Init_problem( HWND hwnd );
//BOOL            bf_APP_RESET_DisplayMode( int scr_width, int scr_hight );
//__declspec(dllexport) //BOOL  bf_APP_Initializuj( HINSTANCE hInstance, int nCmdShow );
//__declspec(dllexport) 
//void  bf_APP_Synchro_dll2App( int* App_bf_MAXX, int* App_bf_MAXY, int* App_bf_SX, int* App_bf_SY,
//                                                    LPDIRECTDRAW* App_bf_lpDD, 
//							                        LPDIRECTDRAWSURFACE* App_bf_lpDDSPrimary, LPDIRECTDRAWSURFACE* App_bf_lpDDSBack,
//                                                    LPDIRECTDRAWPALETTE* App_bf_lpDDPal
//                                                    //BOOL* App_bf_bActive
//							                      );

class bf_CAppRozlisDlg;
class bf_CAppTimerDlg;
class bf_CAppInfoDlg;

//konstanty tlacidiel
#define IDC_APP_BTN_KONIEC       -601
#define IDC_APP_BTN_INFO         -602
#define IDC_APP_BTN_ROZLISENIE   -603 
#define IDC_APP_BTN_TIMER        -604

#define IDD_APP_INFO_DLG                  -1200 
#define IDI_APP_INFO_DLG_LOGO             -1201 
#define IDI_APP_INFO_DLG_ICON             -1202
#define IDL_APP_INFO_DLG_LAB1             -1203
#define IDL_APP_INFO_DLG_LAB2             -1204
#define IDL_APP_INFO_DLG_LAB3             -1205
#define IDL_APP_INFO_DLG_LAB4             -1206
#define IDL_APP_INFO_DLG_LAB5             -1207
#define IDL_APP_INFO_DLG_LAB6             -1208
#define IDL_APP_INFO_DLG_LAB7             -1209
#define IDC_APP_INFO_DLG_OK               -1210
#define IDL_APP_INFO_DLG_OK               -1211
#define IDI_APP_INFO_DLG_OK               -1212

#define IDD_APP_ROZLIS_DLG                -1220
#define IDC_APP_ROZLIS_DLG_DUIR           -1221
#define IDC_APP_ROZLIS_DLG_OK             -1222
#define IDC_APP_ROZLIS_DLG_ZRUS           -1223
#define IDL_APP_ROZLIS_DLG_OK             -1224
#define IDL_APP_ROZLIS_DLG_ZRUS           -1225

#define IDD_APP_TIMER_DLG                 -1230
#define IDC_APP_TIMER_DLG_FAST            -1231
#define IDC_APP_TIMER_DLG_SLOW            -1232
#define IDC_APP_TIMER_DLG_OK              -1233
#define IDL_APP_TIMER_DLG_FAST            -1234
#define IDL_APP_TIMER_DLG_SLOW            -1235
#define IDL_APP_TIMER_DLG_OK              -1236

//konstanty pozadia
//#define bf_backgr_const_NO            0
//#define bf_backgr_const_BLACK         1
//#define bf_backgr_const_BLUE          2
//#define bf_backgr_const_FILE_stretch  4
//#define bf_backgr_const_FILE_center   8
//#define bf_backgr_const_LOGO          16 

//------------------------------------------------------
// konstanty podporovanych jazykov
//------------------------------------------------------
#define bf_c_Lang_EN         1
#define bf_c_Lang_SK         2 

//------------------------------------------------------
// element, polozka volby
//------------------------------------------------------
struct bf_DisplayMode_struct
{   
  int scr_width; 
  int scr_hight;
};

//----------------------------------------------------------------
// Trieda Aplikacie
//----------------------------------------------------------------
class bf_CAppScreen : public bf_CPosCHLO
{
   public:
   HINSTANCE m_hInstance;
	 int m_nCmdShow;
	 
	 //povodne globalky aj ako clenske premenne appky
	 int m_MAXX; int m_MAXY;
	 int m_SX; int m_SY;
	 LPDIRECTDRAW            m_lpDD;           // DirectDraw object
	 LPDIRECTDRAWSURFACE     m_lpDDSPrimary;   // DirectDraw primary surface
	 LPDIRECTDRAWSURFACE     m_lpDDSBack;      // DirectDraw back surface
	 LPDIRECTDRAWPALETTE     m_lpDDPal;        // DirectDraw palette
	 //BOOL                  m_bActive;        // is application active?
	 bool m_TIMER_Disabled;
   bool m_sysCursor;   //ci sa ma zobrazit tradicny systemovy kurzor - sipka

	 char m_LocApp_INI[30];  //nazov .INI fajlu pre konkretnu lokalnu Appku
	 
	 int m_background_color;
	 char m_background_file[100];
	 //bool m_background_file_exists;
	 bool m_background_logo;
		 
   LPSTR m_AppInfo_Title;
	 LPSTR m_AppInfo_Version;
	 LPSTR m_AppInfo_Author;
	 bf_CDas_Surface *m_AppInfo_Icon_rezia; 
	 int m_AppInfo_Icon_fazx; 
	 int m_AppInfo_Icon_fazy;   
   bf_CIcon *m_AppInfo_Icon;  //bezpolohova ikona
		 
	 bool m_TimerRozlisHide;	//ci maju zostat pri starte 2 tlacitka skryte
	 bf_CAppRozlisDlg *m_dlg_AppRozlis;
	 bf_CAppTimerDlg *m_dlg_AppTimer;
	 bf_CAppInfoDlg *m_dlg_AppInfo;
	 
     //bf_CAppScreen(); 
   __declspec(dllexport) bf_CAppScreen( HINSTANCE hInstance, int nCmdShow, char* cLocApp_INI);
	 __declspec(dllexport) virtual ~bf_CAppScreen();
	 //void Init_Private();   // Private Init
	 __declspec(dllexport) void SetBackground( int color, char* file, bool logo );
	 __declspec(dllexport) void SetAppInfo( LPSTR Title, LPSTR Version, LPSTR Author,
	                                        bf_CDas_Surface *Icon_rezia, int Icon_fazx, int Icon_fazy 
										   );
   __declspec(dllexport) void SetAppInfo(LPSTR Title, LPSTR Version, LPSTR Author);
   __declspec(dllexport) void SetSysCursor(bool on_off) { m_sysCursor = on_off; };
   __declspec(dllexport) void SetLang(int hod) { bf_Set_Lang(hod); };
   __declspec(dllexport) int GetLang(int hod) { return bf_Get_Lang(); };

   __declspec(dllexport) virtual void Init() {};  // Public Init
   __declspec(dllexport) virtual int SetupVisual();
	 __declspec(dllexport) virtual void Init2() {};
     //int SetupVisual_Private();
   
	 __declspec(dllexport) int Execute();
	 __declspec(dllexport) void Close();
   __declspec(dllexport) virtual void Do_LOAD_SRF() {};
	 __declspec(dllexport) virtual void Do_RELEASE_SRF() {};
	 __declspec(dllexport) virtual void Do_RESTORE_SRF() {};
	 __declspec(dllexport) virtual void Redraw_Screen( LPDIRECTDRAWSURFACE p_lpDDS ) {};
   __declspec(dllexport) virtual void DrawCursor( LPDIRECTDRAWSURFACE p_lpDDS ) {};
	 __declspec(dllexport) virtual void GetSize( int *ssir, int *vvys );
	 __declspec(dllexport) virtual void HandleWMInteraction( HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam ) {};
	 __declspec(dllexport) virtual bool HandleFWInteraction( int iID, int ivalue, bf_CPos *p_pol = NULL );
	 __declspec(dllexport) virtual void ChangedResolution( int maxx_old, int maxy_old, int maxx_new, int maxy_new );
   //__declspec(dllexport) bf_DSGN_Struct *GetDSGNref();
   __declspec(dllexport) HWND Get_APP_hWnd_GLOB();
};

//------------------------------------------------------
// Dialog na Info
//------------------------------------------------------
class bf_CAppInfoDlg : public bf_CDialog 
{
public:
    bf_CPosIcon *m_Icon;  //polohova
	bf_CLabel *m_Title;
	bf_CLabel *m_Version;
	//bf_CLabel *m_Name;
	
	bf_CAppInfoDlg( bf_CPosCHLO *parent, int iID ); 
    virtual int SetupVisual();
    virtual bool HandleFWInteraction( int iID, int ivalue, bf_CPos *p_pol = NULL);
};

//------------------------------------------------------
// Dialog na nastavovanie rozlisenia
//------------------------------------------------------
class bf_CAppRozlisDlg : public bf_CDialog 
{
public:
  bf_CLabel *m_title;
	int m_SIR; int m_VYS;
	bf_CEDB *edb1, *edb2;
	bf_CDUIR *m_duir_Rozlisenia;

	bf_CAppRozlisDlg( bf_CPosCHLO *parent, int iID ); 
    virtual int SetupVisual();
    virtual bool HandleFWInteraction( int iID, int ivalue, bf_CPos *p_pol = NULL);
	void ChoiceIndex( int ind );
	void SetEdb();
};

//------------------------------------------------------
// Dialog na nastavovanie casovaca
//------------------------------------------------------
class bf_CAppTimerDlg : public bf_CDialog 
{
public:
    bf_CLabel *m_title;
    int m_timer_i;
    int m_timer_delay;

	bf_CEDB *m_edb;

	bf_CAppTimerDlg( bf_CPosCHLO *parent, int iID ); 
    virtual int SetupVisual();
    virtual bool HandleFWInteraction( int iID, int ivalue, bf_CPos *p_pol = NULL);
};

#endif   // __DBONBLIOTFW_PUBL_H__

